/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.struct;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.util.Bytecode;
import pers.XiaoShadiao.NMSLException;

public class InjectionNodes
extends ArrayList<InjectionNode> {
    private static final long serialVersionUID = 1L;

    public InjectionNode add(AbstractInsnNode node) {
        InjectionNode injectionNode = this.get(node);
        if (injectionNode == null) {
            injectionNode = new InjectionNode(node);
            this.add(injectionNode);
        }
        return injectionNode;
    }

    public void replace(AbstractInsnNode oldNode, AbstractInsnNode newNode) {
        InjectionNode injectionNode = this.get(oldNode);
        if (injectionNode != null) {
            injectionNode.replace(newNode);
        }
    }

    public InjectionNode get(AbstractInsnNode node) {
        for (InjectionNode injectionNode : this) {
            if (!injectionNode.matches(node)) continue;
            return injectionNode;
        }
        return null;
    }

    public boolean contains(AbstractInsnNode node) {
        return this.get(node) != null;
    }

    public void remove(AbstractInsnNode node) {
        InjectionNode injectionNode = this.get(node);
        if (injectionNode != null) {
            injectionNode.remove();
        }
    }

    public static class InjectionNode
    implements Comparable<InjectionNode> {
        private static int nextId;
        private AbstractInsnNode currentTarget;
        private Map<String, Object> decorations;
        private final AbstractInsnNode originalTarget;
        private final int id;
        private static final NMSLException \u4f60\u731c\u5bf9\u4e86\u51e0\u4e2a;

        public InjectionNode(AbstractInsnNode node) {
            this.currentTarget = this.originalTarget = node;
            this.id = nextId++;
        }

        public boolean matches(AbstractInsnNode node) {
            return this.originalTarget == node || this.currentTarget == node;
        }

        public boolean isReplaced() {
            return this.originalTarget != this.currentTarget;
        }

        public boolean hasDecoration(String key) {
            return this.decorations != null && this.decorations.get(key) != null;
        }

        public AbstractInsnNode getOriginalTarget() {
            return this.originalTarget;
        }

        static {
            \u4f60\u731c\u5bf9\u4e86\u51e0\u4e2a = new NMSLException("\u4de6\u26c5\u4dc5\u4dff\u2722\u2669\u26c2\u4dc0\u2739\u2685\u4dd9\u274f\u2722\ua679\u4dfa\u26be\u4ddc\u4dfe\u4dcf\u4dca\u2602\u4dd5\u264c\u4dd8\u26ce\u4dca\u4dfe\u2700\u4dcc\ua69f\u4dc1\u2711\u3e26\u278c\u4514");
            nextId = 0;
        }

        public String toString() {
            return String.format("InjectionNode[%s]", Bytecode.describeNode(this.currentTarget).replaceAll("\\s+", " "));
        }

        public boolean isRemoved() {
            return this.currentTarget == null;
        }

        public int getId() {
            return this.id;
        }

        public InjectionNode remove() {
            this.currentTarget = null;
            return this;
        }

        public <V> V getDecoration(String key) {
            return (V)(this.decorations == null ? null : this.decorations.get(key));
        }

        public <V> InjectionNode decorate(String key, V value) {
            if (this.decorations == null) {
                this.decorations = new HashMap<String, Object>();
            }
            this.decorations.put(key, value);
            return this;
        }

        public AbstractInsnNode getCurrentTarget() {
            return this.currentTarget;
        }

        public InjectionNode replace(AbstractInsnNode target) {
            this.currentTarget = target;
            return this;
        }

        @Override
        public int compareTo(InjectionNode other) {
            return other == null ? Integer.MAX_VALUE : this.hashCode() - other.hashCode();
        }
    }
}

