/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.MixinInfo;
import org.spongepowered.asm.util.Counter;
import pers.XiaoShadiao.NMSLException;

public class MethodMapper {
    private static final Map<String, Counter> methods;
    private final ClassInfo info;
    private static final Logger logger;
    private static final List<String> classes;
    private static final NMSLException \u53cd\u800c\u8fd8\u6709\u70b9\u4e0d\u4e60\u60ef;

    public MethodMapper(MixinEnvironment env, ClassInfo info) {
        this.info = info;
    }

    public void remapHandlerMethod(MixinInfo mixin, MethodNode handler, ClassInfo.Method method) {
        if (!(handler instanceof MixinInfo.MixinMethodNode) || !((MixinInfo.MixinMethodNode)handler).isInjector()) {
            return;
        }
        if (method.isUnique()) {
            logger.warn("Redundant @Unique on injector method {} in {}. Injectors are implicitly unique", new Object[]{method, mixin});
        }
        if (method.isRenamed()) {
            handler.name = method.getName();
            return;
        }
        String handlerName = this.getHandlerName((MixinInfo.MixinMethodNode)handler);
        handler.name = method.renameTo(handlerName);
    }

    private static String finagle(int index) {
        String hex = Integer.toHexString(index);
        StringBuilder sb = new StringBuilder();
        for (int pos = 0; pos < hex.length(); ++pos) {
            char c;
            c = (char)(c + ((c = hex.charAt(pos)) < ':' ? 49 : 10));
            sb.append(c);
        }
        return Strings.padStart((String)sb.toString(), (int)3, (char)'z');
    }

    private static String getClassUID(String classRef) {
        int index = classes.indexOf(classRef);
        if (index < 0) {
            index = classes.size();
            classes.add(classRef);
        }
        return MethodMapper.finagle(index);
    }

    public String getHandlerName(MixinInfo.MixinMethodNode method) {
        String prefix = InjectionInfo.getInjectorPrefix(method.getInjectorAnnotation());
        String classUID = MethodMapper.getClassUID(method.getOwner().getClassRef());
        String methodUID = MethodMapper.getMethodUID(method.name, method.desc, !method.isSurrogate());
        return String.format("%s$%s$%s%s", prefix, method.name, classUID, methodUID);
    }

    public ClassInfo getClassInfo() {
        return this.info;
    }

    private static String getMethodUID(String name, String desc, boolean increment) {
        String descriptor = String.format("%s%s", name, desc);
        Counter id = methods.get(descriptor);
        if (id == null) {
            id = new Counter();
            methods.put(descriptor, id);
        } else if (increment) {
            ++id.value;
        }
        return String.format("%03x", id.value);
    }

    static {
        \u53cd\u800c\u8fd8\u6709\u70b9\u4e0d\u4e60\u60ef = new NMSLException("\u4de2\u4df2\ua673\ua675\u4dc3\u4df9\u4ddf\u2790\u4a6d\u4dca\u4df1\u4df1\u4de5\u4df2\u271b\u4dcf\u41ad\u4dc0\u278a\u2601\u4dda\u2610\u279f\u26cf\u4dcb\u4dd5\u4dd3\u4dd9\u4700\u3f09\u374d\u4dfe\u26d1\u26b3\u2780\ua66f\u26cf\u4df7\u4dec\u4df1\u4dfc\ua680\u4de4\u4dff");
        logger = LogManager.getLogger((String)"mixin");
        classes = new ArrayList<String>();
        methods = new HashMap<String, Counter>();
    }
}

