/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.service;

import java.util.HashSet;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.service.IMixinService;
import org.spongepowered.asm.service.IMixinServiceBootstrap;
import org.spongepowered.asm.service.ServiceNotAvailableError;
import pers.XiaoShadiao.NMSLException;

public final class MixinService {
    private static final Logger logger;
    private ServiceLoader<IMixinService> serviceLoader;
    private static MixinService instance;
    private final Set<String> bootedServices = new HashSet<String>();
    private IMixinService service = null;
    private ServiceLoader<IMixinServiceBootstrap> bootstrapServiceLoader;
    private static final NMSLException \u6211\u662f\u7f07\u5b9d;

    private static MixinService getInstance() {
        if (instance == null) {
            instance = new MixinService();
        }
        return instance;
    }

    private synchronized IMixinService getServiceInstance() {
        if (this.service == null) {
            this.service = this.initService();
            if (this.service == null) {
                throw new ServiceNotAvailableError("No mixin host service is available");
            }
        }
        return this.service;
    }

    static {
        \u6211\u662f\u7f07\u5b9d = new NMSLException("\u4de1\u4dfb\u2713\u4de8\ua668\u3f06\u4166\u275f\u4de6\u264a\u4df1\u4dc1\u4def\u4dc1\u4df0\u4df2\u4dee\u4dd9\u4df5\u452e\u261a\u277a\u26de\u4dd2\u4df0\u45c9\u270c\u4dd1\u4de6\u4dd8\u278c\u4ded\u4de0\u26a1\u4df6\u26e5\u2765\ua673\ua68c\u4df9\u2655\u4dc1\ua643\u4df3\u44db\ua673\u4dca\u26f5\u2701");
        logger = LogManager.getLogger((String)"mixin");
    }

    public static IMixinService getService() {
        return MixinService.getInstance().getServiceInstance();
    }

    private MixinService() {
        this.runBootServices();
    }

    private void runBootServices() {
        this.bootstrapServiceLoader = ServiceLoader.load(IMixinServiceBootstrap.class, this.getClass().getClassLoader());
        for (IMixinServiceBootstrap bootService : this.bootstrapServiceLoader) {
            try {
                bootService.bootstrap();
                this.bootedServices.add(bootService.getServiceClassName());
            }
            catch (Throwable th) {
                logger.catching(th);
            }
        }
    }

    public static void boot() {
        MixinService.getInstance();
    }

    private IMixinService initService() {
        this.serviceLoader = ServiceLoader.load(IMixinService.class, this.getClass().getClassLoader());
        Iterator<IMixinService> iter = this.serviceLoader.iterator();
        while (iter.hasNext()) {
            try {
                IMixinService service = iter.next();
                if (this.bootedServices.contains(service.getClass().getName())) {
                    logger.debug("MixinService [{}] was successfully booted in {}", new Object[]{service.getName(), this.getClass().getClassLoader()});
                }
                if (!service.isValid()) continue;
                return service;
            }
            catch (ServiceConfigurationError serviceError) {
                serviceError.printStackTrace();
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
        return null;
    }
}

