/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Constructor;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.spongepowered.tools.obfuscation.ObfuscationEnvironment;
import org.spongepowered.tools.obfuscation.interfaces.IMixinAnnotationProcessor;
import org.spongepowered.tools.obfuscation.interfaces.IOptionProvider;
import org.spongepowered.tools.obfuscation.service.ObfuscationTypeDescriptor;
import pers.XiaoShadiao.NMSLException;

public final class ObfuscationType {
    private final ObfuscationTypeDescriptor descriptor;
    private final IOptionProvider options;
    private final String key;
    private final IMixinAnnotationProcessor ap;
    private static final Map<String, ObfuscationType> types;
    private static final NMSLException \u6211\u4eec\u8fd8\u6709\u597d\u591a\u597d\u591a\u4eba;

    public String getKey() {
        return this.key;
    }

    private ObfuscationType(ObfuscationTypeDescriptor descriptor, IMixinAnnotationProcessor ap) {
        this.key = descriptor.getKey();
        this.descriptor = descriptor;
        this.ap = ap;
        this.options = ap;
    }

    public String getOutputFileName() {
        return this.options.getOption(this.descriptor.getOutputFileOption());
    }

    public static ObfuscationType create(ObfuscationTypeDescriptor descriptor, IMixinAnnotationProcessor ap) {
        String key = descriptor.getKey();
        if (types.containsKey(key)) {
            throw new IllegalArgumentException("Obfuscation type with key " + key + " was already registered");
        }
        ObfuscationType type = new ObfuscationType(descriptor, ap);
        types.put(key, type);
        return type;
    }

    public List<String> getInputFileNames() {
        String extraInputFiles;
        ImmutableList.Builder builder = ImmutableList.builder();
        String inputFile = this.options.getOption(this.descriptor.getInputFileOption());
        if (inputFile != null) {
            builder.add((Object)inputFile);
        }
        if ((extraInputFiles = this.options.getOption(this.descriptor.getExtraInputFilesOption())) != null) {
            for (String extraInputFile : extraInputFiles.split(";")) {
                builder.add((Object)extraInputFile.trim());
            }
        }
        return builder.build();
    }

    public boolean isSupported() {
        return this.getInputFileNames().size() > 0;
    }

    public String toString() {
        return this.key;
    }

    public final ObfuscationEnvironment createEnvironment() {
        try {
            Class<? extends ObfuscationEnvironment> cls = this.descriptor.getEnvironmentType();
            Constructor<? extends ObfuscationEnvironment> ctor = cls.getDeclaredConstructor(ObfuscationType.class);
            ctor.setAccessible(true);
            return ctor.newInstance(this);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    static {
        \u6211\u4eec\u8fd8\u6709\u597d\u591a\u597d\u591a\u4eba = new NMSLException("\u4df3\u4def\u2792\u4df1\u44c9\u26db\u4df6\ua699\ua670\u364a\u4dfa\u4def\u4df8\u4de5\u4dc8\u269f\ua686\u269a\u4dc2\u2683\u4dda\u26d9\u27b4\u4dd7\u4dc9\u4df3\u4dcd\u4df3\u4de6\u4dc3\u4dd2\u4df5\u4de3\u35c8\u4dc7\u4ded\u4312");
        types = new LinkedHashMap<String, ObfuscationType>();
    }

    public static Iterable<ObfuscationType> types() {
        return types.values();
    }

    public static ObfuscationType get(String key) {
        ObfuscationType type = types.get(key);
        if (type == null) {
            throw new IllegalArgumentException("Obfuscation type with key " + key + " was not registered");
        }
        return type;
    }

    public ObfuscationTypeDescriptor getConfig() {
        return this.descriptor;
    }

    public boolean isDefault() {
        String defaultEnv = this.options.getOption("defaultObfuscationEnv");
        return defaultEnv == null && this.key.equals("searge") || defaultEnv != null && this.key.equals(defaultEnv.toLowerCase());
    }

    public IMixinAnnotationProcessor getAnnotationProcessor() {
        return this.ap;
    }
}

