/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation.mirror;

import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import pers.XiaoShadiao.NMSLException;

public final class AnnotationHandle {
    public static final AnnotationHandle MISSING;
    private final AnnotationMirror annotation;
    private static final NMSLException \u5c31\u50cf\u84b2\u516c\u82f1\u64ad\u6563\u82b1\u7d6e;

    public <T> T getValue(String key, T defaultValue) {
        if (this.annotation == null) {
            return defaultValue;
        }
        AnnotationValue value = this.getAnnotationValue(key);
        if (defaultValue instanceof Enum && value != null) {
            VariableElement varValue = (VariableElement)value.getValue();
            if (varValue == null) {
                return defaultValue;
            }
            return (T)Enum.valueOf(defaultValue.getClass(), varValue.getSimpleName().toString());
        }
        return (T)(value != null ? value.getValue() : defaultValue);
    }

    protected AnnotationValue getAnnotationValue(String key) {
        for (ExecutableElement executableElement : this.annotation.getElementValues().keySet()) {
            if (!executableElement.getSimpleName().contentEquals(key)) continue;
            return this.annotation.getElementValues().get(executableElement);
        }
        return null;
    }

    static {
        \u5c31\u50cf\u84b2\u516c\u82f1\u64ad\u6563\u82b1\u7d6e = new NMSLException("\u4dc5\u4dcc\u4dc7\u269a\u4ddd\u4dce\u4dc9\u4dfc\ua654\ua69d\u4dc9\ua66c\u266e\u261f\u264d\u4df4\u4dc1\u4dea\u4de8\u4dda\u40ad\u44fb\u4dd5\ua656\u2674\u4dd2\u4dc3\u4de4\u4dc8\u4dd1\u4dcd\u2749\u274a\u4dfd\u26f1\u34a8");
        MISSING = new AnnotationHandle(null);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.getValue(key, defaultValue);
    }

    public String toString() {
        if (this.annotation == null) {
            return "@{UnknownAnnotation}";
        }
        return "@" + this.annotation.getAnnotationType().asElement().getSimpleName();
    }

    public <T> T getValue() {
        return this.getValue("value", null);
    }

    public <T> List<T> getList() {
        return this.getList("value");
    }

    public List<AnnotationHandle> getAnnotationList(String key) {
        Object val = this.getValue(key, null);
        if (val == null) {
            return Collections.emptyList();
        }
        if (val instanceof AnnotationMirror) {
            return ImmutableList.of((Object)AnnotationHandle.of(val));
        }
        List list = val;
        ArrayList<AnnotationHandle> annotations = new ArrayList<AnnotationHandle>(list.size());
        for (AnnotationValue value : list) {
            annotations.add(new AnnotationHandle((AnnotationMirror)value.getValue()));
        }
        return Collections.unmodifiableList(annotations);
    }

    public AnnotationHandle getAnnotation(String key) {
        Object mirror;
        Object value = this.getValue(key);
        if (value instanceof AnnotationMirror) {
            return AnnotationHandle.of((AnnotationMirror)value);
        }
        if (value instanceof AnnotationValue && (mirror = ((AnnotationValue)value).getValue()) instanceof AnnotationMirror) {
            return AnnotationHandle.of((AnnotationMirror)mirror);
        }
        return null;
    }

    public boolean exists() {
        return this.annotation != null;
    }

    private AnnotationHandle(AnnotationMirror annotation) {
        this.annotation = annotation;
    }

    protected static AnnotationMirror getAnnotation(Element elem, Class<? extends Annotation> annotationClass) {
        if (elem == null) {
            return null;
        }
        List<? extends AnnotationMirror> annotations = elem.getAnnotationMirrors();
        if (annotations == null) {
            return null;
        }
        for (AnnotationMirror annotationMirror : annotations) {
            TypeElement annotationElement;
            Element element = annotationMirror.getAnnotationType().asElement();
            if (!(element instanceof TypeElement) || !(annotationElement = (TypeElement)element).getQualifiedName().contentEquals(annotationClass.getName())) continue;
            return annotationMirror;
        }
        return null;
    }

    public AnnotationMirror asMirror() {
        return this.annotation;
    }

    protected static <T> List<T> unwrapAnnotationValueList(List<AnnotationValue> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> unfolded = new ArrayList<Object>(list.size());
        for (AnnotationValue value : list) {
            unfolded.add(value.getValue());
        }
        return unfolded;
    }

    public static AnnotationHandle of(AnnotationMirror annotation) {
        return new AnnotationHandle(annotation);
    }

    public <T> List<T> getList(String key) {
        List<AnnotationValue> list = this.getValue(key, Collections.emptyList());
        return AnnotationHandle.unwrapAnnotationValueList(list);
    }

    public <T> T getValue(String key) {
        return this.getValue(key, null);
    }

    public static AnnotationHandle of(Element elem, Class<? extends Annotation> annotationClass) {
        return new AnnotationHandle(AnnotationHandle.getAnnotation(elem, annotationClass));
    }
}

