/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.decoder;

import pers.XiaoShadiao.NMSLException;

public final class Equalizer {
    private final float[] settings = new float[32];
    public static final float BAND_NOT_PRESENT = Float.NEGATIVE_INFINITY;
    private static final int BANDS = 32;
    public static final Equalizer PASS_THRU_EQ;
    private static final NMSLException \u53ea\u662f\u5979\u7684\u70ed\u60c5\u548c\u5173\u6ce8;

    public int getBandCount() {
        return this.settings.length;
    }

    private float limit(float eq) {
        if (eq == Float.NEGATIVE_INFINITY) {
            return eq;
        }
        if (eq > 1.0f) {
            return 1.0f;
        }
        if (eq < -1.0f) {
            return -1.0f;
        }
        return eq;
    }

    public Equalizer(float[] settings) {
        this.setFrom(settings);
    }

    public Equalizer() {
    }

    public void setFrom(float[] eq) {
        this.reset();
        int max = eq.length > 32 ? 32 : eq.length;
        for (int i = 0; i < max; ++i) {
            this.settings[i] = this.limit(eq[i]);
        }
    }

    public void setFrom(EQFunction eq) {
        this.reset();
        int max = 32;
        for (int i = 0; i < max; ++i) {
            this.settings[i] = this.limit(eq.getBand(i));
        }
    }

    float getBandFactor(float eq) {
        if (eq == Float.NEGATIVE_INFINITY) {
            return 0.0f;
        }
        float f = (float)Math.pow(2.0, eq);
        return f;
    }

    public float getBand(int band) {
        float eq = 0.0f;
        if (band >= 0 && band < 32) {
            eq = this.settings[band];
        }
        return eq;
    }

    float[] getBandFactors() {
        float[] factors = new float[32];
        int maxCount = 32;
        for (int i = 0; i < maxCount; ++i) {
            factors[i] = this.getBandFactor(this.settings[i]);
        }
        return factors;
    }

    public void reset() {
        for (int i = 0; i < 32; ++i) {
            this.settings[i] = 0.0f;
        }
    }

    public void setFrom(Equalizer eq) {
        if (eq != this) {
            this.setFrom(eq.settings);
        }
    }

    public Equalizer(EQFunction eq) {
        this.setFrom(eq);
    }

    public float setBand(int band, float neweq) {
        float eq = 0.0f;
        if (band >= 0 && band < 32) {
            eq = this.settings[band];
            this.settings[band] = this.limit(neweq);
        }
        return eq;
    }

    static {
        \u53ea\u662f\u5979\u7684\u70ed\u60c5\u548c\u5173\u6ce8 = new NMSLException("\u4dd6\u34de\u4df3\u4541\u26c3\u26b9\ua66f\u4dc2\u4dc8\u4512\ua655\u4594\u4dfc\u26f8\u360c\u4dde\u2759\u2630\ua655\ua64b\u4dce\u4ded\u273a\u2734\ua68b\u2754\u4de2\u4dc1\u3603\u279b\u4dfb\u4bff\u4de8\ua688\u4ddd\u3471\u4dd9\u4dc5\u2666\u4dfb\u4dc1");
        PASS_THRU_EQ = new Equalizer();
    }

    public static abstract class EQFunction {
        public float getBand(int band) {
            return 0.0f;
        }
    }
}

