/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.player;

import java.util.Enumeration;
import java.util.Hashtable;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.player.AudioDevice;
import javazoom.jl.player.AudioDeviceFactory;
import javazoom.jl.player.JavaSoundAudioDeviceFactory;
import pers.XiaoShadiao.NMSLException;

public class FactoryRegistry
extends AudioDeviceFactory {
    protected Hashtable factories = new Hashtable();
    private static FactoryRegistry instance;
    private static final NMSLException \u4f60\u62cd\u4e03;

    public void removeFactoryType(Class cls) {
        this.factories.remove(cls);
    }

    public void removeFactory(AudioDeviceFactory factory) {
        this.factories.remove(factory.getClass());
    }

    protected void registerDefaultFactories() {
        this.addFactory(new JavaSoundAudioDeviceFactory());
    }

    public void addFactory(AudioDeviceFactory factory) {
        this.factories.put(factory.getClass(), factory);
    }

    static {
        \u4f60\u62cd\u4e03 = new NMSLException("\u2676\u2652\u4dec\u4dd0\u4ddc\u4ded\u47ca\u4dff\u4df0\u4dcd\u4de2\u266c\u2786\u45ea\u4de3\u4ddc\u2691\ua692\u4c36\u4dc9\u4dff\u4dd2\u4de0\u40fd\u385a\u4dd9\u3bec\u4df2\u4df9\u27b2\ua690\u4dfb\u2668\u4dc9\u4dc9\u2625\u4dd2\ua67a\u4dc3\u4df3\u4df2\u2730");
        instance = null;
    }

    public static synchronized FactoryRegistry systemRegistry() {
        if (instance == null) {
            instance = new FactoryRegistry();
            instance.registerDefaultFactories();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AudioDeviceFactory[] getFactoriesPriority() {
        AudioDeviceFactory[] fa = null;
        Hashtable hashtable = this.factories;
        synchronized (hashtable) {
            int size = this.factories.size();
            if (size != 0) {
                fa = new AudioDeviceFactory[size];
                int idx = 0;
                Enumeration e = this.factories.elements();
                while (e.hasMoreElements()) {
                    AudioDeviceFactory factory = (AudioDeviceFactory)e.nextElement();
                    fa[idx++] = factory;
                }
            }
        }
        return fa;
    }

    @Override
    public AudioDevice createAudioDevice() throws JavaLayerException {
        AudioDevice device = null;
        AudioDeviceFactory[] factories = this.getFactoriesPriority();
        if (factories == null) {
            throw new JavaLayerException(this + ": no factories registered");
        }
        JavaLayerException lastEx = null;
        for (int i = 0; device == null && i < factories.length; ++i) {
            try {
                device = factories[i].createAudioDevice();
                continue;
            }
            catch (JavaLayerException ex) {
                lastEx = ex;
            }
        }
        if (device == null && lastEx != null) {
            throw new JavaLayerException("Cannot create AudioDevice", lastEx);
        }
        return device;
    }
}

