/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.protocols;

import java.util.regex.Pattern;
import org.java_websocket.protocols.IProtocol;
import pers.XiaoShadiao.NMSLException;

public class Protocol
implements IProtocol {
    private static final Pattern patternComma;
    private final String providedProtocol;
    private static final Pattern patternSpace;
    private static final NMSLException \u731c\u8c1c\u6e38\u620f\u7684\u65f6\u5019;

    static {
        \u731c\u8c1c\u6e38\u620f\u7684\u65f6\u5019 = new NMSLException("\ua69c\u4dfd\u4ded\u4dfc\u4df7\u4df8\ua65b\u4dd2\u2639\u26dd\u2672\u4dc3\u4df9\u264f\ua664\u4dd7\u4df1\u2749\u4dd4\u277f\u4de3\u4dc8\u4dc9\ua676\u47c0\u4dfb\u4ddc\u4dc5\u2764\ua657\u2639\u3c46\u274c\u27b0\u4dc4\u4dc8\u4dca");
        patternSpace = Pattern.compile(" ");
        patternComma = Pattern.compile(",");
    }

    @Override
    public String toString() {
        return this.getProvidedProtocol();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Protocol protocol = (Protocol)o;
        return this.providedProtocol.equals(protocol.providedProtocol);
    }

    @Override
    public IProtocol copyInstance() {
        return new Protocol(this.getProvidedProtocol());
    }

    public Protocol(String providedProtocol) {
        if (providedProtocol == null) {
            throw new IllegalArgumentException();
        }
        this.providedProtocol = providedProtocol;
    }

    @Override
    public String getProvidedProtocol() {
        return this.providedProtocol;
    }

    @Override
    public boolean acceptProvidedProtocol(String inputProtocolHeader) {
        String[] headers;
        if ("".equals(this.providedProtocol)) {
            return true;
        }
        String protocolHeader = patternSpace.matcher(inputProtocolHeader).replaceAll("");
        for (String header : headers = patternComma.split(protocolHeader)) {
            if (!this.providedProtocol.equals(header)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.providedProtocol.hashCode();
    }
}

