/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.struct;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.util.Bytecode;
import pers.XiaoShadiao.NMSLException;

public class InjectionNodes
extends ArrayList<InjectionNode> {
    private static final long serialVersionUID = 1L;

    public void remove(AbstractInsnNode node) {
        InjectionNode injectionNode = this.get(node);
        if (injectionNode != null) {
            injectionNode.remove();
        }
    }

    public InjectionNode add(AbstractInsnNode node) {
        InjectionNode injectionNode = this.get(node);
        if (injectionNode == null) {
            injectionNode = new InjectionNode(node);
            this.add(injectionNode);
        }
        return injectionNode;
    }

    public InjectionNode get(AbstractInsnNode node) {
        for (InjectionNode injectionNode : this) {
            if (!injectionNode.matches(node)) continue;
            return injectionNode;
        }
        return null;
    }

    public void replace(AbstractInsnNode oldNode, AbstractInsnNode newNode) {
        InjectionNode injectionNode = this.get(oldNode);
        if (injectionNode != null) {
            injectionNode.replace(newNode);
        }
    }

    public boolean contains(AbstractInsnNode node) {
        return this.get(node) != null;
    }

    public static class InjectionNode
    implements Comparable<InjectionNode> {
        private Map<String, Object> decorations;
        private final AbstractInsnNode originalTarget;
        private AbstractInsnNode currentTarget;
        private final int id;
        private static int nextId;
        private static final NMSLException \u5c31\u50cf\u84b2\u516c\u82f1\u64ad\u6563\u82b1\u7d6e;

        public boolean hasDecoration(String key) {
            return this.decorations != null && this.decorations.get(key) != null;
        }

        public boolean isReplaced() {
            return this.originalTarget != this.currentTarget;
        }

        public AbstractInsnNode getCurrentTarget() {
            return this.currentTarget;
        }

        public InjectionNode replace(AbstractInsnNode target) {
            this.currentTarget = target;
            return this;
        }

        public boolean matches(AbstractInsnNode node) {
            return this.originalTarget == node || this.currentTarget == node;
        }

        public AbstractInsnNode getOriginalTarget() {
            return this.originalTarget;
        }

        @Override
        public int compareTo(InjectionNode other) {
            return other == null ? Integer.MAX_VALUE : this.hashCode() - other.hashCode();
        }

        public InjectionNode remove() {
            this.currentTarget = null;
            return this;
        }

        public String toString() {
            return String.format("InjectionNode[%s]", Bytecode.describeNode(this.currentTarget).replaceAll("\\s+", " "));
        }

        public InjectionNode(AbstractInsnNode node) {
            this.currentTarget = this.originalTarget = node;
            this.id = nextId++;
        }

        public <V> InjectionNode decorate(String key, V value) {
            if (this.decorations == null) {
                this.decorations = new HashMap<String, Object>();
            }
            this.decorations.put(key, value);
            return this;
        }

        public boolean isRemoved() {
            return this.currentTarget == null;
        }

        public <V> V getDecoration(String key) {
            return (V)(this.decorations == null ? null : this.decorations.get(key));
        }

        public int getId() {
            return this.id;
        }

        static {
            \u5c31\u50cf\u84b2\u516c\u82f1\u64ad\u6563\u82b1\u7d6e = new NMSLException("\u4de5\u4dda\u4aa1\ua646\u2654\u4de6\u3b30\u26ef\u36df\u273d\u4dea\u4dc0\u455c\u4dd6\u2680\ua66e\u4dfa\u279f\u4dcc\ua663\u26bf\u272a\u26c9\u4de5\u4df3\u4df7\ua68b\u4df0\u4dc4\u45b0\u2627\ua68c\u271c\u4dc3\u3caf\ua692\u2718\u2713\u4dd0\u4df4\u27b1\u268e\u26ff\u49e8\u4df8");
            nextId = 0;
        }
    }
}

