/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.struct;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.code.Injector;
import org.spongepowered.asm.mixin.injection.invoke.ModifyConstantInjector;
import org.spongepowered.asm.mixin.injection.points.BeforeConstant;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.transformer.MixinTargetContext;
import pers.XiaoShadiao.NMSLException;

public class ModifyConstantInjectionInfo
extends InjectionInfo {
    private static final String CONSTANT_ANNOTATION_CLASS;
    private static final NMSLException \u5982\u679c\u660e\u5929\u89c1\u4e0d\u5230;

    @Override
    protected String getDescription() {
        return "Constant modifier method";
    }

    static {
        \u5982\u679c\u660e\u5929\u89c1\u4e0d\u5230 = new NMSLException("\u2627\u4dde\u26fe\u4dfe\u2660\ua691\u342d\ua64f\u4df7\u4dc4\ua664\u4ddc\u4de1\u4dec\u4dc3\u4df7\u274b\ua679\u270b\u4dcf\u4df2\u3ecb\u362b\u4ddd\u4ddb\ua64f\u4ae0\u4dcc\u44b9\u2749\u4def\u26c6\u4dcf\u49c8\ua645\u26f0\u26b6");
        CONSTANT_ANNOTATION_CLASS = Constant.class.getName().replace('.', '/');
    }

    @Override
    protected List<AnnotationNode> readInjectionPoints(String type) {
        ImmutableList ats = super.readInjectionPoints(type);
        if (ats.isEmpty()) {
            AnnotationNode c = new AnnotationNode(CONSTANT_ANNOTATION_CLASS);
            c.visit("log", Boolean.TRUE);
            ats = ImmutableList.of((Object)c);
        }
        return ats;
    }

    @Override
    public String getSliceId(String id) {
        return Strings.nullToEmpty((String)id);
    }

    public ModifyConstantInjectionInfo(MixinTargetContext mixin, MethodNode method, AnnotationNode annotation) {
        super(mixin, method, annotation, "constant");
    }

    @Override
    protected void parseInjectionPoints(List<AnnotationNode> ats) {
        Type returnType = Type.getReturnType(this.method.desc);
        for (AnnotationNode at : ats) {
            this.injectionPoints.add(new BeforeConstant(this.getContext(), at, returnType.getDescriptor()));
        }
    }

    @Override
    protected Injector parseInjector(AnnotationNode injectAnnotation) {
        return new ModifyConstantInjector(this);
    }
}

