/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.struct;

import org.spongepowered.asm.lib.tree.FieldInsnNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.mixin.transformer.throwables.MixinTransformerError;
import org.spongepowered.asm.util.Bytecode;
import pers.XiaoShadiao.NMSLException;

public abstract class MemberRef {
    private static final int[] H_OPCODES;
    private static final NMSLException \u671d\u7740\u660e\u5929\u524d\u8fdb\u5427;

    static {
        \u671d\u7740\u660e\u5929\u524d\u8fdb\u5427 = new NMSLException("\u4dca\u4dc6\u4dff\u4dc8\u4de6\ua68e\u4dc9\u4ded\u4b24\ua64a\u273c\ua69e\u4df4\u4dd0\ua661\u4dd7\ua660\u27a3\u4de5\u4dfb\u4deb\ua699\u46e9\u348f\u4dce\u3cd4\u4dc7\u4dcf\u4df1\u4ddb\u4dea\u4df8\ua66a\u27b9\u4ddf");
        H_OPCODES = new int[]{0, 180, 178, 181, 179, 182, 184, 183, 183, 185};
    }

    public abstract int getOpcode();

    public abstract String getDesc();

    static int opcodeFromTag(int tag) {
        return tag >= 0 && tag < H_OPCODES.length ? H_OPCODES[tag] : 0;
    }

    public abstract String getOwner();

    public abstract String getName();

    static int tagFromOpcode(int opcode) {
        for (int tag = 1; tag < H_OPCODES.length; ++tag) {
            if (H_OPCODES[tag] != opcode) continue;
            return tag;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MemberRef)) {
            return false;
        }
        MemberRef other = (MemberRef)obj;
        return this.getOpcode() == other.getOpcode() && this.getOwner().equals(other.getOwner()) && this.getName().equals(other.getName()) && this.getDesc().equals(other.getDesc());
    }

    public String toString() {
        String name = Bytecode.getOpcodeName(this.getOpcode());
        return String.format("%s for %s.%s%s%s", name, this.getOwner(), this.getName(), this.isField() ? ":" : "", this.getDesc());
    }

    public abstract void setOpcode(int var1);

    public abstract void setName(String var1);

    public int hashCode() {
        return this.toString().hashCode();
    }

    public abstract void setOwner(String var1);

    public abstract void setDesc(String var1);

    public abstract boolean isField();

    public static final class Handle
    extends MemberRef {
        private org.spongepowered.asm.lib.Handle handle;

        @Override
        public void setName(String name) {
            boolean itf = this.handle.getTag() == 9;
            this.handle = new org.spongepowered.asm.lib.Handle(this.handle.getTag(), this.handle.getOwner(), name, this.handle.getDesc(), itf);
        }

        @Override
        public void setOpcode(int opcode) {
            int tag = MemberRef.tagFromOpcode(opcode);
            if (tag == 0) {
                throw new MixinTransformerError("Invalid opcode " + Bytecode.getOpcodeName(opcode) + " for method handle " + this.handle + ".");
            }
            boolean itf = tag == 9;
            this.handle = new org.spongepowered.asm.lib.Handle(tag, this.handle.getOwner(), this.handle.getName(), this.handle.getDesc(), itf);
        }

        @Override
        public void setOwner(String owner) {
            boolean itf = this.handle.getTag() == 9;
            this.handle = new org.spongepowered.asm.lib.Handle(this.handle.getTag(), owner, this.handle.getName(), this.handle.getDesc(), itf);
        }

        public org.spongepowered.asm.lib.Handle getMethodHandle() {
            return this.handle;
        }

        public Handle(org.spongepowered.asm.lib.Handle handle) {
            this.handle = handle;
        }

        @Override
        public String getDesc() {
            return this.handle.getDesc();
        }

        @Override
        public int getOpcode() {
            int opcode = MemberRef.opcodeFromTag(this.handle.getTag());
            if (opcode == 0) {
                throw new MixinTransformerError("Invalid tag " + this.handle.getTag() + " for method handle " + this.handle + ".");
            }
            return opcode;
        }

        @Override
        public boolean isField() {
            switch (this.handle.getTag()) {
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    return false;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return true;
                }
            }
            throw new MixinTransformerError("Invalid tag " + this.handle.getTag() + " for method handle " + this.handle + ".");
        }

        @Override
        public String getOwner() {
            return this.handle.getOwner();
        }

        @Override
        public void setDesc(String desc) {
            boolean itf = this.handle.getTag() == 9;
            this.handle = new org.spongepowered.asm.lib.Handle(this.handle.getTag(), this.handle.getOwner(), this.handle.getName(), desc, itf);
        }

        @Override
        public String getName() {
            return this.handle.getName();
        }
    }

    public static final class Field
    extends MemberRef {
        public final FieldInsnNode insn;
        private static final int OPCODES = 183;

        @Override
        public boolean isField() {
            return true;
        }

        @Override
        public String getDesc() {
            return this.insn.desc;
        }

        @Override
        public void setName(String name) {
            this.insn.name = name;
        }

        @Override
        public void setDesc(String desc) {
            this.insn.desc = desc;
        }

        @Override
        public void setOwner(String owner) {
            this.insn.owner = owner;
        }

        @Override
        public String getOwner() {
            return this.insn.owner;
        }

        @Override
        public void setOpcode(int opcode) {
            if ((opcode & 0xB7) == 0) {
                throw new IllegalArgumentException("Invalid opcode for field instruction: 0x" + Integer.toHexString(opcode));
            }
            this.insn.setOpcode(opcode);
        }

        @Override
        public String getName() {
            return this.insn.name;
        }

        @Override
        public int getOpcode() {
            return this.insn.getOpcode();
        }

        public Field(FieldInsnNode insn) {
            this.insn = insn;
        }
    }

    public static final class Method
    extends MemberRef {
        private static final int OPCODES = 191;
        public final MethodInsnNode insn;

        @Override
        public void setOwner(String owner) {
            this.insn.owner = owner;
        }

        @Override
        public String getDesc() {
            return this.insn.desc;
        }

        @Override
        public String getOwner() {
            return this.insn.owner;
        }

        @Override
        public String getName() {
            return this.insn.name;
        }

        @Override
        public void setDesc(String desc) {
            this.insn.desc = desc;
        }

        public Method(MethodInsnNode insn) {
            this.insn = insn;
        }

        @Override
        public int getOpcode() {
            return this.insn.getOpcode();
        }

        @Override
        public boolean isField() {
            return false;
        }

        @Override
        public void setOpcode(int opcode) {
            if ((opcode & 0xBF) == 0) {
                throw new IllegalArgumentException("Invalid opcode for method instruction: 0x" + Integer.toHexString(opcode));
            }
            this.insn.setOpcode(opcode);
        }

        @Override
        public void setName(String name) {
            this.insn.name = name;
        }
    }
}

