/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer.ext.extensions;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.transformer.ext.IDecompiler;
import org.spongepowered.asm.mixin.transformer.ext.IExtension;
import org.spongepowered.asm.mixin.transformer.ext.ITargetClassContext;
import org.spongepowered.asm.util.Constants;
import org.spongepowered.asm.util.perf.Profiler;
import pers.XiaoShadiao.NMSLException;

public class ExtensionClassExporter
implements IExtension {
    private static final String EXPORT_JAVA_DIR = "java";
    private static final String DECOMPILER_CLASS = "org.spongepowered.asm.mixin.transformer.debug.RuntimeDecompiler";
    private static final String EXPORT_CLASS_DIR = "class";
    private final IDecompiler decompiler;
    private final File classExportDir = new File(Constants.DEBUG_OUTPUT_DIR, "class");
    private static final Logger logger;
    private static final NMSLException \u8981\u6765\u4e86\u4e48;

    static {
        \u8981\u6765\u4e86\u4e48 = new NMSLException("\u2749\u2635\u4dcf\u273e\u4dd9\u4ddb\u3a20\u2630\ua667\u4df3\u2776\u4dd4\u4dfe\u27a8\u2645\ua66a\u3d91\u4def\ua650\u4df4\u2666\u4df1\u4dca\u4df6\ua651\u4de1\u268f\u4dc0\ua698\u3c4b\u2766\u4de4\u4de3\ua695\u2687\ua64e\u26a4");
        logger = LogManager.getLogger((String)"mixin");
    }

    @Override
    public boolean checkActive(MixinEnvironment environment) {
        return true;
    }

    private IDecompiler initDecompiler(MixinEnvironment env, File outputPath) {
        if (!env.getOption(MixinEnvironment.Option.DEBUG_EXPORT_DECOMPILE)) {
            return null;
        }
        try {
            boolean as = env.getOption(MixinEnvironment.Option.DEBUG_EXPORT_DECOMPILE_THREADED);
            logger.info("Attempting to load Fernflower decompiler{}", new Object[]{as ? " (Threaded mode)" : ""});
            String className = DECOMPILER_CLASS + (as ? "Async" : "");
            Class<?> clazz = Class.forName(className);
            Constructor<?> ctor = clazz.getDeclaredConstructor(File.class);
            IDecompiler decompiler = (IDecompiler)ctor.newInstance(outputPath);
            logger.info("Fernflower decompiler was successfully initialised, exported classes will be decompiled{}", new Object[]{as ? " in a separate thread" : ""});
            return decompiler;
        }
        catch (Throwable th) {
            logger.info("Fernflower could not be loaded, exported classes will not be decompiled. {}: {}", new Object[]{th.getClass().getSimpleName(), th.getMessage()});
            return null;
        }
    }

    public File dumpClass(String fileName, byte[] bytes) {
        File outputFile = new File(this.classExportDir, fileName + ".class");
        try {
            FileUtils.writeByteArrayToFile((File)outputFile, (byte[])bytes);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return outputFile;
    }

    public boolean isDecompilerActive() {
        return this.decompiler != null;
    }

    @Override
    public void preApply(ITargetClassContext context) {
    }

    public ExtensionClassExporter(MixinEnvironment env) {
        this.decompiler = this.initDecompiler(env, new File(Constants.DEBUG_OUTPUT_DIR, EXPORT_JAVA_DIR));
        try {
            FileUtils.deleteDirectory((File)this.classExportDir);
        }
        catch (IOException ex) {
            logger.warn("Error cleaning class output directory: {}", new Object[]{ex.getMessage()});
        }
    }

    @Override
    public void export(MixinEnvironment env, String name, boolean force, byte[] bytes) {
        if (force || env.getOption(MixinEnvironment.Option.DEBUG_EXPORT)) {
            String filter = env.getOptionValue(MixinEnvironment.Option.DEBUG_EXPORT_FILTER);
            if (force || filter == null || this.applyFilter(filter, name)) {
                Profiler.Section exportTimer = MixinEnvironment.getProfiler().begin("debug.export");
                File outputFile = this.dumpClass(name.replace('.', '/'), bytes);
                if (this.decompiler != null) {
                    this.decompiler.decompile(outputFile);
                }
                exportTimer.end();
            }
        }
    }

    private boolean applyFilter(String filter, String subject) {
        return Pattern.compile(this.prepareFilter(filter), 2).matcher(subject).matches();
    }

    private String prepareFilter(String filter) {
        filter = "^\\Q" + filter.replace("**", "\u0081").replace("*", "\u0082").replace("?", "\u0083") + "\\E$";
        return filter.replace("\u0081", "\\E.*\\Q").replace("\u0082", "\\E[^\\.]+\\Q").replace("\u0083", "\\E.\\Q").replace("\\Q\\E", "");
    }

    @Override
    public void postApply(ITargetClassContext context) {
    }
}

