/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.obfuscation.mapping.common;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import org.spongepowered.asm.obfuscation.mapping.IMapping;

public class MappingField
implements IMapping<MappingField> {
    private final String desc;
    private final String owner;
    private final String name;

    public MappingField(String owner, String name, String desc) {
        this.owner = owner;
        this.name = name;
        this.desc = desc;
    }

    public String toString() {
        return String.format("L%s;%s:%s", this.getOwner(), this.getName(), Strings.nullToEmpty((String)this.getDesc()));
    }

    @Override
    public String serialise() {
        return this.toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.toString()});
    }

    @Override
    public final String getOwner() {
        return this.owner;
    }

    @Override
    public IMapping.Type getType() {
        return IMapping.Type.FIELD;
    }

    @Override
    public MappingField getSuper() {
        return null;
    }

    public MappingField(String owner, String name) {
        this(owner, name, null);
    }

    @Override
    public final String getDesc() {
        return this.desc;
    }

    @Override
    public MappingField copy() {
        return new MappingField(this.getOwner(), this.getName(), this.getDesc());
    }

    @Override
    public final String getSimpleName() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MappingField) {
            return Objects.equal((Object)this.toString(), (Object)((MappingField)obj).toString());
        }
        return false;
    }

    @Override
    public MappingField remap(String newName) {
        return new MappingField(this.getOwner(), newName, this.getDesc());
    }

    @Override
    public MappingField transform(String newDesc) {
        return new MappingField(this.getOwner(), this.getName(), newDesc);
    }

    @Override
    public MappingField move(String newOwner) {
        return new MappingField(newOwner, this.getName(), this.getDesc());
    }
}

