/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.service;

import java.util.HashSet;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.service.IMixinService;
import org.spongepowered.asm.service.IMixinServiceBootstrap;
import org.spongepowered.asm.service.ServiceNotAvailableError;
import pers.XiaoShadiao.NMSLException;

public final class MixinService {
    private final Set<String> bootedServices = new HashSet<String>();
    private ServiceLoader<IMixinService> serviceLoader;
    private IMixinService service = null;
    private ServiceLoader<IMixinServiceBootstrap> bootstrapServiceLoader;
    private static MixinService instance;
    private static final Logger logger;
    private static final NMSLException \u53ea\u662f\u5979\u7684\u70ed\u60c5\u548c\u5173\u6ce8;

    private synchronized IMixinService getServiceInstance() {
        if (this.service == null) {
            this.service = this.initService();
            if (this.service == null) {
                throw new ServiceNotAvailableError("No mixin host service is available");
            }
        }
        return this.service;
    }

    static {
        \u53ea\u662f\u5979\u7684\u70ed\u60c5\u548c\u5173\u6ce8 = new NMSLException("\u4dc4\u4dfe\u26b6\u4868\u4dfe\u4dd3\u3a45\u41ba\u4de6\u4deb\u2645\u492e\u4dcb\u488c\u4dea\u4df7\u4ddc\u4df3\ua669\u260b\u4dc1\u2640\u4b91\u4de5\u2687\u4dc5\u4deb\u2798\u4dfe\u278f\u2699\u264e\u4dce\u45a5\u4def\u277a\u372f\u278c\u4def\u26b1\ua654\u4df2\u4de1\u3b18");
        logger = LogManager.getLogger((String)"mixin");
    }

    private IMixinService initService() {
        this.serviceLoader = ServiceLoader.load(IMixinService.class, this.getClass().getClassLoader());
        Iterator<IMixinService> iter = this.serviceLoader.iterator();
        while (iter.hasNext()) {
            try {
                IMixinService service = iter.next();
                if (this.bootedServices.contains(service.getClass().getName())) {
                    logger.debug("MixinService [{}] was successfully booted in {}", new Object[]{service.getName(), this.getClass().getClassLoader()});
                }
                if (!service.isValid()) continue;
                return service;
            }
            catch (ServiceConfigurationError serviceError) {
                serviceError.printStackTrace();
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
        return null;
    }

    private MixinService() {
        this.runBootServices();
    }

    public static void boot() {
        MixinService.getInstance();
    }

    private static MixinService getInstance() {
        if (instance == null) {
            instance = new MixinService();
        }
        return instance;
    }

    private void runBootServices() {
        this.bootstrapServiceLoader = ServiceLoader.load(IMixinServiceBootstrap.class, this.getClass().getClassLoader());
        for (IMixinServiceBootstrap bootService : this.bootstrapServiceLoader) {
            try {
                bootService.bootstrap();
                this.bootedServices.add(bootService.getServiceClassName());
            }
            catch (Throwable th) {
                logger.catching(th);
            }
        }
    }

    public static IMixinService getService() {
        return MixinService.getInstance().getServiceInstance();
    }
}

