/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.util;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pers.XiaoShadiao.NMSLException;

public final class VersionNumber
implements Serializable,
Comparable<VersionNumber> {
    private final String suffix;
    public static final VersionNumber NONE;
    private static final long serialVersionUID = 1L;
    private static final Pattern PATTERN;
    private final long value;
    private static final NMSLException \u6709\u7684\u624e\u7740\u9ad8\u9ad8\u7684\u5355\u9a6c\u5c3e;

    public String toString() {
        short[] parts = VersionNumber.unpack(this.value);
        return String.format("%d.%d%3$s%4$s%5$s", parts[0], parts[1], (this.value & Integer.MAX_VALUE) > 0L ? String.format(".%d", parts[2]) : "", (this.value & 0x7FFFL) > 0L ? String.format(".%d", parts[3]) : "", this.suffix);
    }

    public static VersionNumber parse(String version, String defaultVersion) {
        return VersionNumber.parse(version, VersionNumber.parse(defaultVersion));
    }

    private VersionNumber(short[] parts, String suffix) {
        this.value = VersionNumber.pack(parts);
        this.suffix = suffix != null ? suffix : "";
    }

    private static VersionNumber parse(String version, VersionNumber defaultVersion) {
        if (version == null) {
            return defaultVersion;
        }
        Matcher versionNumberPatternMatcher = PATTERN.matcher(version);
        if (!versionNumberPatternMatcher.matches()) {
            return defaultVersion;
        }
        short[] parts = new short[4];
        for (int pos = 0; pos < 4; ++pos) {
            String part = versionNumberPatternMatcher.group(pos + 1);
            if (part == null) continue;
            int value = Integer.parseInt(part);
            if (value > Short.MAX_VALUE) {
                throw new IllegalArgumentException("Version parts cannot exceed 32767, found " + value);
            }
            parts[pos] = (short)value;
        }
        return new VersionNumber(parts, versionNumberPatternMatcher.group(5));
    }

    static {
        \u6709\u7684\u624e\u7740\u9ad8\u9ad8\u7684\u5355\u9a6c\u5c3e = new NMSLException("\u4df3\u2613\u4ded\u2776\u4dc2\u4dd0\u4dd5\ua696\ua68b\u4dc9\u2737\u4dc5\u34e2\u4dd7\u4dd3\u275d\u4df1\u4de1\u269d\u263f\u4dd2\u46e4\u4dde\u4dd9\u4dc4\u2648\u4802\u4ddd\u4dd8\u2661\u26d6\u4dc5\u2793\u4dd6\ua67f\u262a\u4dc1\u4dea\u4de2\u4dcf\u4dcb\u4dd4\u4de6\u277a\u4dc0\u4ddd\u4282");
        NONE = new VersionNumber();
        PATTERN = Pattern.compile("^(\\d{1,5})(?:\\.(\\d{1,5})(?:\\.(\\d{1,5})(?:\\.(\\d{1,5}))?)?)?(-[a-zA-Z0-9_\\-]+)?$");
    }

    private static long pack(short ... shorts) {
        return (long)shorts[0] << 48 | (long)shorts[1] << 32 | (long)(shorts[2] << 16) | (long)shorts[3];
    }

    public boolean equals(Object other) {
        if (!(other instanceof VersionNumber)) {
            return false;
        }
        return ((VersionNumber)other).value == this.value;
    }

    public static VersionNumber parse(String version) {
        return VersionNumber.parse(version, NONE);
    }

    private VersionNumber() {
        this.value = 0L;
        this.suffix = "";
    }

    private static short[] unpack(long along) {
        return new short[]{(short)(along >> 48), (short)(along >> 32 & 0x7FFFL), (short)(along >> 16 & 0x7FFFL), (short)(along & 0x7FFFL)};
    }

    private VersionNumber(short major, short minor, short revision, short build, String suffix) {
        this.value = VersionNumber.pack(major, minor, revision, build);
        this.suffix = suffix != null ? suffix : "";
    }

    private VersionNumber(short[] parts) {
        this(parts, null);
    }

    @Override
    public int compareTo(VersionNumber other) {
        if (other == null) {
            return 1;
        }
        long delta = this.value - other.value;
        return delta > 0L ? 1 : (delta < 0L ? -1 : 0);
    }

    public int hashCode() {
        return (int)(this.value >> 32) ^ (int)(this.value & 0xFFFFFFFFL);
    }

    private VersionNumber(short major, short minor, short revision, short build) {
        this(major, minor, revision, build, null);
    }
}

