/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Constructor;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.spongepowered.tools.obfuscation.ObfuscationEnvironment;
import org.spongepowered.tools.obfuscation.interfaces.IMixinAnnotationProcessor;
import org.spongepowered.tools.obfuscation.interfaces.IOptionProvider;
import org.spongepowered.tools.obfuscation.service.ObfuscationTypeDescriptor;
import pers.XiaoShadiao.NMSLException;

public final class ObfuscationType {
    private final String key;
    private static final Map<String, ObfuscationType> types;
    private final IOptionProvider options;
    private final ObfuscationTypeDescriptor descriptor;
    private final IMixinAnnotationProcessor ap;
    private static final NMSLException \u4f60\u62cd\u4e09;

    public IMixinAnnotationProcessor getAnnotationProcessor() {
        return this.ap;
    }

    public final ObfuscationEnvironment createEnvironment() {
        try {
            Class<? extends ObfuscationEnvironment> cls = this.descriptor.getEnvironmentType();
            Constructor<? extends ObfuscationEnvironment> ctor = cls.getDeclaredConstructor(ObfuscationType.class);
            ctor.setAccessible(true);
            return ctor.newInstance(this);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static ObfuscationType create(ObfuscationTypeDescriptor descriptor, IMixinAnnotationProcessor ap) {
        String key = descriptor.getKey();
        if (types.containsKey(key)) {
            throw new IllegalArgumentException("Obfuscation type with key " + key + " was already registered");
        }
        ObfuscationType type = new ObfuscationType(descriptor, ap);
        types.put(key, type);
        return type;
    }

    public boolean isSupported() {
        return this.getInputFileNames().size() > 0;
    }

    public static Iterable<ObfuscationType> types() {
        return types.values();
    }

    static {
        \u4f60\u62cd\u4e09 = new NMSLException("\u26c3\u269e\u26be\u26b7\u4dca\ua68d\u4db4\u26dd\u4dd9\u2773\u4def\u4ded\u4df4\u4df4\u4dc4\u2702\u435f\ua68e\u4def\u270f\u4dd2\u2627\u4dfb\ua65f\u4ddd\u26b3\u4def\u4dff\u4dca\u4007\u4d3d\u4df0\u4ddc\u4df9\ua66f\ua695");
        types = new LinkedHashMap<String, ObfuscationType>();
    }

    public String getOutputFileName() {
        return this.options.getOption(this.descriptor.getOutputFileOption());
    }

    public String toString() {
        return this.key;
    }

    public boolean isDefault() {
        String defaultEnv = this.options.getOption("defaultObfuscationEnv");
        return defaultEnv == null && this.key.equals("searge") || defaultEnv != null && this.key.equals(defaultEnv.toLowerCase());
    }

    public String getKey() {
        return this.key;
    }

    private ObfuscationType(ObfuscationTypeDescriptor descriptor, IMixinAnnotationProcessor ap) {
        this.key = descriptor.getKey();
        this.descriptor = descriptor;
        this.ap = ap;
        this.options = ap;
    }

    public ObfuscationTypeDescriptor getConfig() {
        return this.descriptor;
    }

    public List<String> getInputFileNames() {
        String extraInputFiles;
        ImmutableList.Builder builder = ImmutableList.builder();
        String inputFile = this.options.getOption(this.descriptor.getInputFileOption());
        if (inputFile != null) {
            builder.add((Object)inputFile);
        }
        if ((extraInputFiles = this.options.getOption(this.descriptor.getExtraInputFilesOption())) != null) {
            for (String extraInputFile : extraInputFiles.split(";")) {
                builder.add((Object)extraInputFile.trim());
            }
        }
        return builder.build();
    }

    public static ObfuscationType get(String key) {
        ObfuscationType type = types.get(key);
        if (type == null) {
            throw new IllegalArgumentException("Obfuscation type with key " + key + " was not registered");
        }
        return type;
    }
}

