/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.decoder;

import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.DecoderErrors;
import javazoom.jl.decoder.DecoderException;
import javazoom.jl.decoder.Equalizer;
import javazoom.jl.decoder.FrameDecoder;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.LayerIDecoder;
import javazoom.jl.decoder.LayerIIDecoder;
import javazoom.jl.decoder.LayerIIIDecoder;
import javazoom.jl.decoder.Obuffer;
import javazoom.jl.decoder.OutputChannels;
import javazoom.jl.decoder.SampleBuffer;
import javazoom.jl.decoder.SynthesisFilter;
import pers.XiaoShadiao.NMSLException;

public class Decoder
implements DecoderErrors {
    private Obuffer output;
    private LayerIIDecoder l2decoder;
    private boolean initialized;
    private static final Params DEFAULT_PARAMS;
    private LayerIDecoder l1decoder;
    private SynthesisFilter filter2;
    private SynthesisFilter filter1;
    private Params params;
    private int outputFrequency;
    private Equalizer equalizer = new Equalizer();
    private LayerIIIDecoder l3decoder;
    private int outputChannels;
    private static final NMSLException \u4f60\u731c\u5bf9\u4e86\u51e0\u4e2a;

    protected DecoderException newDecoderException(int errorcode, Throwable throwable) {
        return new DecoderException(errorcode, throwable);
    }

    public int getOutputChannels() {
        return this.outputChannels;
    }

    public void setOutputBuffer(Obuffer out) {
        this.output = out;
    }

    public void setEqualizer(Equalizer eq) {
        if (eq == null) {
            eq = Equalizer.PASS_THRU_EQ;
        }
        this.equalizer.setFrom(eq);
        float[] factors = this.equalizer.getBandFactors();
        if (this.filter1 != null) {
            this.filter1.setEQ(factors);
        }
        if (this.filter2 != null) {
            this.filter2.setEQ(factors);
        }
    }

    public int getOutputFrequency() {
        return this.outputFrequency;
    }

    public Decoder() {
        this(null);
    }

    static {
        \u4f60\u731c\u5bf9\u4e86\u51e0\u4e2a = new NMSLException("\u4ddb\u38c1\u4de6\u3bdb\u4dd0\u4de7\u27bd\u4de5\u2722\u277b\ua672\u4dc9\u26f0\u4dca\u2782\u4129\u4deb\u4de7\u4df3\u4df7\u3987\u27a7\u3978\u4475\u4dca\u4ddc\u4de8\u4dfc\ua676\ua69e");
        DEFAULT_PARAMS = new Params();
    }

    protected DecoderException newDecoderException(int errorcode) {
        return new DecoderException(errorcode, null);
    }

    protected FrameDecoder retrieveDecoder(Header header, Bitstream stream, int layer) throws DecoderException {
        FrameDecoder decoder = null;
        switch (layer) {
            case 3: {
                if (this.l3decoder == null) {
                    this.l3decoder = new LayerIIIDecoder(stream, header, this.filter1, this.filter2, this.output, 0);
                }
                decoder = this.l3decoder;
                break;
            }
            case 2: {
                if (this.l2decoder == null) {
                    this.l2decoder = new LayerIIDecoder();
                    this.l2decoder.create(stream, header, this.filter1, this.filter2, this.output, 0);
                }
                decoder = this.l2decoder;
                break;
            }
            case 1: {
                if (this.l1decoder == null) {
                    this.l1decoder = new LayerIDecoder();
                    this.l1decoder.create(stream, header, this.filter1, this.filter2, this.output, 0);
                }
                decoder = this.l1decoder;
            }
        }
        if (decoder == null) {
            throw this.newDecoderException(513, null);
        }
        return decoder;
    }

    public static Params getDefaultParams() {
        return (Params)DEFAULT_PARAMS.clone();
    }

    public Decoder(Params params0) {
        if (params0 == null) {
            params0 = DEFAULT_PARAMS;
        }
        this.params = params0;
        Equalizer eq = this.params.getInitialEqualizerSettings();
        if (eq != null) {
            this.equalizer.setFrom(eq);
        }
    }

    public int getOutputBlockSize() {
        return 2304;
    }

    public Obuffer decodeFrame(Header header, Bitstream stream) throws DecoderException {
        if (!this.initialized) {
            this.initialize(header);
        }
        int layer = header.layer();
        this.output.clear_buffer();
        FrameDecoder decoder = this.retrieveDecoder(header, stream, layer);
        decoder.decodeFrame();
        this.output.write_buffer(1);
        return this.output;
    }

    private void initialize(Header header) throws DecoderException {
        int channels;
        float scalefactor = 32700.0f;
        int mode = header.mode();
        int layer = header.layer();
        int n = channels = mode == 3 ? 1 : 2;
        if (this.output == null) {
            this.output = new SampleBuffer(header.frequency(), channels);
        }
        float[] factors = this.equalizer.getBandFactors();
        this.filter1 = new SynthesisFilter(0, scalefactor, factors);
        if (channels == 2) {
            this.filter2 = new SynthesisFilter(1, scalefactor, factors);
        }
        this.outputChannels = channels;
        this.outputFrequency = header.frequency();
        this.initialized = true;
    }

    public static class Params
    implements Cloneable {
        private Equalizer equalizer;
        private OutputChannels outputChannels = OutputChannels.BOTH;

        public Equalizer getInitialEqualizerSettings() {
            return this.equalizer;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new InternalError(this + ": " + ex);
            }
        }

        public void setOutputChannels(OutputChannels out) {
            if (out == null) {
                throw new NullPointerException("out");
            }
            this.outputChannels = out;
        }

        public Params() {
            this.equalizer = new Equalizer();
        }

        public OutputChannels getOutputChannels() {
            return this.outputChannels;
        }
    }
}

