/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.decoder;

import pers.XiaoShadiao.NMSLException;

public final class Equalizer {
    private final float[] settings = new float[32];
    public static final Equalizer PASS_THRU_EQ;
    private static final int BANDS = 32;
    public static final float BAND_NOT_PRESENT = Float.NEGATIVE_INFINITY;
    private static final NMSLException \u6211\u62cd\u4e5d;

    float getBandFactor(float eq) {
        if (eq == Float.NEGATIVE_INFINITY) {
            return 0.0f;
        }
        float f = (float)Math.pow(2.0, eq);
        return f;
    }

    public Equalizer() {
    }

    static {
        \u6211\u62cd\u4e5d = new NMSLException("\u4de7\u4df6\u4dd3\u26d6\u4dda\u3462\u4df9\u27b7\u4de5\u4dfa\u263e\u4ddd\u4dcc\u26b6\u3c96\ua65f\u4dd9\u4764\ua66f\u4dd6\u4ad5\u4dc6\u27a0\u279a\u4df1\u26ff\u272b\u26a4\u4df2\u46aa\u493f\u4de8\u4dd4\u4397\u4dfe\u4dc0\u42b6\u26ea\ua64b\u2796\u2768");
        PASS_THRU_EQ = new Equalizer();
    }

    float[] getBandFactors() {
        float[] factors = new float[32];
        int maxCount = 32;
        for (int i = 0; i < maxCount; ++i) {
            factors[i] = this.getBandFactor(this.settings[i]);
        }
        return factors;
    }

    public float setBand(int band, float neweq) {
        float eq = 0.0f;
        if (band >= 0 && band < 32) {
            eq = this.settings[band];
            this.settings[band] = this.limit(neweq);
        }
        return eq;
    }

    public float getBand(int band) {
        float eq = 0.0f;
        if (band >= 0 && band < 32) {
            eq = this.settings[band];
        }
        return eq;
    }

    public Equalizer(float[] settings) {
        this.setFrom(settings);
    }

    public void setFrom(Equalizer eq) {
        if (eq != this) {
            this.setFrom(eq.settings);
        }
    }

    private float limit(float eq) {
        if (eq == Float.NEGATIVE_INFINITY) {
            return eq;
        }
        if (eq > 1.0f) {
            return 1.0f;
        }
        if (eq < -1.0f) {
            return -1.0f;
        }
        return eq;
    }

    public Equalizer(EQFunction eq) {
        this.setFrom(eq);
    }

    public int getBandCount() {
        return this.settings.length;
    }

    public void setFrom(EQFunction eq) {
        this.reset();
        int max = 32;
        for (int i = 0; i < max; ++i) {
            this.settings[i] = this.limit(eq.getBand(i));
        }
    }

    public void setFrom(float[] eq) {
        this.reset();
        int max = eq.length > 32 ? 32 : eq.length;
        for (int i = 0; i < max; ++i) {
            this.settings[i] = this.limit(eq[i]);
        }
    }

    public void reset() {
        for (int i = 0; i < 32; ++i) {
            this.settings[i] = 0.0f;
        }
    }

    public static abstract class EQFunction {
        public float getBand(int band) {
            return 0.0f;
        }
    }
}

