/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.protocols;

import java.util.regex.Pattern;
import org.java_websocket.protocols.IProtocol;
import pers.XiaoShadiao.NMSLException;

public class Protocol
implements IProtocol {
    private static final Pattern patternSpace;
    private static final Pattern patternComma;
    private final String providedProtocol;
    private static final NMSLException \u8fd9\u4e2a\u5f52\u7f07\u5b89;

    static {
        \u8fd9\u4e2a\u5f52\u7f07\u5b89 = new NMSLException("\u26ed\u4dc0\u4dcc\ua659\u4dde\u2703\u4dfb\u46ed\u279a\u26fd\u4dc4\u4de6\u4ac5\ua68f\u272e\u4dcb\ua682\u4dc0\u2748\u4de7\u4dca\u26d5\u4aa3\u2709\u2712\u270c\u4de6\u4dd0\u4ddd\u27a9\u4ddb");
        patternSpace = Pattern.compile(" ");
        patternComma = Pattern.compile(",");
    }

    @Override
    public boolean acceptProvidedProtocol(String inputProtocolHeader) {
        String[] headers;
        if ("".equals(this.providedProtocol)) {
            return true;
        }
        String protocolHeader = patternSpace.matcher(inputProtocolHeader).replaceAll("");
        for (String header : headers = patternComma.split(protocolHeader)) {
            if (!this.providedProtocol.equals(header)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.providedProtocol.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Protocol protocol = (Protocol)o;
        return this.providedProtocol.equals(protocol.providedProtocol);
    }

    public Protocol(String providedProtocol) {
        if (providedProtocol == null) {
            throw new IllegalArgumentException();
        }
        this.providedProtocol = providedProtocol;
    }

    @Override
    public String getProvidedProtocol() {
        return this.providedProtocol;
    }

    @Override
    public IProtocol copyInstance() {
        return new Protocol(this.getProvidedProtocol());
    }

    @Override
    public String toString() {
        return this.getProvidedProtocol();
    }
}

