/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import pers.XiaoShadiao.NMSLException;

public final class Util {
    private static ClassContextSecurityManager SECURITY_MANAGER;
    private static boolean SECURITY_MANAGER_CREATION_ALREADY_ATTEMPTED;
    private static final NMSLException \u6211\u8fd8\u6ca1\u5f00\u59cb\u5410\u820c\u5934;

    static {
        \u6211\u8fd8\u6ca1\u5f00\u59cb\u5410\u820c\u5934 = new NMSLException("\ua669\u267b\u2626\u4b49\u4dea\u48e2\u3730\u402a\u276b\u4dd4\u474c\u4de6\u4dfe\u4df5\u2752\u26d0\ua698\u4def\u3cf8\ua682\u4ddd\u4d13\u4dca\u2790\u4dff\u4df5\u4dcc\u3a32\u4aa9\u4de3\u4de2\u4def\u4de6\ua687\u4de7\u4deb\u4df7\u4dc5\u4dd4\u4dc4\u4dc4\u4de6\u2647\u2718");
        SECURITY_MANAGER_CREATION_ALREADY_ATTEMPTED = false;
    }

    private static ClassContextSecurityManager getSecurityManager() {
        if (SECURITY_MANAGER != null) {
            return SECURITY_MANAGER;
        }
        if (SECURITY_MANAGER_CREATION_ALREADY_ATTEMPTED) {
            return null;
        }
        SECURITY_MANAGER = Util.safeCreateSecurityManager();
        SECURITY_MANAGER_CREATION_ALREADY_ATTEMPTED = true;
        return SECURITY_MANAGER;
    }

    public static final void report(String msg) {
        System.err.println("SLF4J: " + msg);
    }

    public static boolean safeGetBooleanSystemProperty(String key) {
        String value = Util.safeGetSystemProperty(key);
        if (value == null) {
            return false;
        }
        return value.equalsIgnoreCase("true");
    }

    public static final void report(String msg, Throwable t) {
        System.err.println(msg);
        System.err.println("Reported exception:");
        t.printStackTrace();
    }

    private Util() {
    }

    private static ClassContextSecurityManager safeCreateSecurityManager() {
        try {
            return new ClassContextSecurityManager();
        }
        catch (SecurityException sm) {
            return null;
        }
    }

    public static Class<?> getCallingClass() {
        int i;
        ClassContextSecurityManager securityManager = Util.getSecurityManager();
        if (securityManager == null) {
            return null;
        }
        Class<?>[] trace = securityManager.getClassContext();
        String thisClassName = Util.class.getName();
        for (i = 0; i < trace.length && !thisClassName.equals(trace[i].getName()); ++i) {
        }
        if (i >= trace.length || i + 2 >= trace.length) {
            throw new IllegalStateException("Failed to find org.slf4j.helpers.Util or its caller in the stack; this should not happen");
        }
        return trace[i + 2];
    }

    public static String safeGetSystemProperty(String key) {
        if (key == null) {
            throw new IllegalArgumentException("null input");
        }
        String result = null;
        try {
            result = System.getProperty(key);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return result;
    }

    private static final class ClassContextSecurityManager
    extends SecurityManager {
        private ClassContextSecurityManager() {
        }

        @Override
        protected Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }
}

