/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.struct;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.util.Bytecode;
import pers.XiaoShadiao.NMSLException;

public class InjectionNodes
extends ArrayList<InjectionNode> {
    private static final long serialVersionUID = 1L;

    public boolean contains(AbstractInsnNode node) {
        return this.get(node) != null;
    }

    public void remove(AbstractInsnNode node) {
        InjectionNode injectionNode = this.get(node);
        if (injectionNode != null) {
            injectionNode.remove();
        }
    }

    public void replace(AbstractInsnNode oldNode, AbstractInsnNode newNode) {
        InjectionNode injectionNode = this.get(oldNode);
        if (injectionNode != null) {
            injectionNode.replace(newNode);
        }
    }

    public InjectionNode get(AbstractInsnNode node) {
        for (InjectionNode injectionNode : this) {
            if (!injectionNode.matches(node)) continue;
            return injectionNode;
        }
        return null;
    }

    public InjectionNode add(AbstractInsnNode node) {
        InjectionNode injectionNode = this.get(node);
        if (injectionNode == null) {
            injectionNode = new InjectionNode(node);
            this.add(injectionNode);
        }
        return injectionNode;
    }

    public static class InjectionNode
    implements Comparable<InjectionNode> {
        private AbstractInsnNode currentTarget;
        private Map<String, Object> decorations;
        private static int nextId;
        private final AbstractInsnNode originalTarget;
        private final int id;
        private static final NMSLException \u544a\u8bc9\u5979\u6ca1\u4e8b\u7684;

        public <V> InjectionNode decorate(String key, V value) {
            if (this.decorations == null) {
                this.decorations = new HashMap<String, Object>();
            }
            this.decorations.put(key, value);
            return this;
        }

        public InjectionNode(AbstractInsnNode node) {
            this.currentTarget = this.originalTarget = node;
            this.id = nextId++;
        }

        static {
            \u544a\u8bc9\u5979\u6ca1\u4e8b\u7684 = new NMSLException("\u4dc3\u2724\u4dc3\u4dc9\u4df7\ua687\ua664\u26a8\ua68b\u4dc0\u4de8\u2659\u4df5\ua66c\u2767\u2779\u3bb1\u4ddc\ua68d\u3b4d\u4dfe\u4de5\ua67a\u2758\u26d2\u26dc\u4dfc\u450e\u274a\u267e\u4cbc\u26b4\u26f0\u4dcb\u4230\u4ded\u4ddc\u4dd3\u4dec\u4de8");
            nextId = 0;
        }

        @Override
        public int compareTo(InjectionNode other) {
            return other == null ? Integer.MAX_VALUE : this.hashCode() - other.hashCode();
        }

        public boolean isReplaced() {
            return this.originalTarget != this.currentTarget;
        }

        public <V> V getDecoration(String key) {
            return (V)(this.decorations == null ? null : this.decorations.get(key));
        }

        public AbstractInsnNode getCurrentTarget() {
            return this.currentTarget;
        }

        public AbstractInsnNode getOriginalTarget() {
            return this.originalTarget;
        }

        public int getId() {
            return this.id;
        }

        public boolean matches(AbstractInsnNode node) {
            return this.originalTarget == node || this.currentTarget == node;
        }

        public InjectionNode replace(AbstractInsnNode target) {
            this.currentTarget = target;
            return this;
        }

        public boolean hasDecoration(String key) {
            return this.decorations != null && this.decorations.get(key) != null;
        }

        public InjectionNode remove() {
            this.currentTarget = null;
            return this;
        }

        public boolean isRemoved() {
            return this.currentTarget == null;
        }

        public String toString() {
            return String.format("InjectionNode[%s]", Bytecode.describeNode(this.currentTarget).replaceAll("\\s+", " "));
        }
    }
}

