/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Constructor;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.spongepowered.tools.obfuscation.ObfuscationEnvironment;
import org.spongepowered.tools.obfuscation.interfaces.IMixinAnnotationProcessor;
import org.spongepowered.tools.obfuscation.interfaces.IOptionProvider;
import org.spongepowered.tools.obfuscation.service.ObfuscationTypeDescriptor;
import pers.XiaoShadiao.NMSLException;

public final class ObfuscationType {
    private static final Map<String, ObfuscationType> types;
    private final IOptionProvider options;
    private final IMixinAnnotationProcessor ap;
    private final ObfuscationTypeDescriptor descriptor;
    private final String key;
    private static final NMSLException \u4eba\u591a\u529b\u91cf\u5927;

    public List<String> getInputFileNames() {
        String extraInputFiles;
        ImmutableList.Builder builder = ImmutableList.builder();
        String inputFile = this.options.getOption(this.descriptor.getInputFileOption());
        if (inputFile != null) {
            builder.add((Object)inputFile);
        }
        if ((extraInputFiles = this.options.getOption(this.descriptor.getExtraInputFilesOption())) != null) {
            for (String extraInputFile : extraInputFiles.split(";")) {
                builder.add((Object)extraInputFile.trim());
            }
        }
        return builder.build();
    }

    public String getOutputFileName() {
        return this.options.getOption(this.descriptor.getOutputFileOption());
    }

    public ObfuscationTypeDescriptor getConfig() {
        return this.descriptor;
    }

    public String getKey() {
        return this.key;
    }

    public final ObfuscationEnvironment createEnvironment() {
        try {
            Class<? extends ObfuscationEnvironment> cls = this.descriptor.getEnvironmentType();
            Constructor<? extends ObfuscationEnvironment> ctor = cls.getDeclaredConstructor(ObfuscationType.class);
            ctor.setAccessible(true);
            return ctor.newInstance(this);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private ObfuscationType(ObfuscationTypeDescriptor descriptor, IMixinAnnotationProcessor ap) {
        this.key = descriptor.getKey();
        this.descriptor = descriptor;
        this.ap = ap;
        this.options = ap;
    }

    public static ObfuscationType get(String key) {
        ObfuscationType type = types.get(key);
        if (type == null) {
            throw new IllegalArgumentException("Obfuscation type with key " + key + " was not registered");
        }
        return type;
    }

    public boolean isSupported() {
        return this.getInputFileNames().size() > 0;
    }

    public static Iterable<ObfuscationType> types() {
        return types.values();
    }

    public static ObfuscationType create(ObfuscationTypeDescriptor descriptor, IMixinAnnotationProcessor ap) {
        String key = descriptor.getKey();
        if (types.containsKey(key)) {
            throw new IllegalArgumentException("Obfuscation type with key " + key + " was already registered");
        }
        ObfuscationType type = new ObfuscationType(descriptor, ap);
        types.put(key, type);
        return type;
    }

    public IMixinAnnotationProcessor getAnnotationProcessor() {
        return this.ap;
    }

    public boolean isDefault() {
        String defaultEnv = this.options.getOption("defaultObfuscationEnv");
        return defaultEnv == null && this.key.equals("searge") || defaultEnv != null && this.key.equals(defaultEnv.toLowerCase());
    }

    static {
        \u4eba\u591a\u529b\u91cf\u5927 = new NMSLException("\u270a\u3b4f\u4315\u3e19\u278d\u4df8\u448f\u4dd9\u412a\u27aa\u4dcf\u4df3\u4d6e\u2664\u4df0\ua64a\ua662\u4dfa\u26bf\u2623\u4b89\ua65d\u4dd1\u389d\u4ddc\u46b3\u4dcd\u4de2\ua696\u3af8\u4dcd\u264a\u4dd8");
        types = new LinkedHashMap<String, ObfuscationType>();
    }

    public String toString() {
        return this.key;
    }
}

