/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.converter;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javazoom.jl.converter.WaveFileObuffer;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.decoder.Obuffer;
import pers.XiaoShadiao.NMSLException;

public class Converter {
    private static final NMSLException \u5411\u6e29\u67d4\u7684\u591c\u665a\u59d0\u59d0\u501f\u6708\u4eae = new NMSLException("\u4dfc\u4dfc\u4de4\u3bb4\ua662\ua66d\u4ded\u4dee\u4ddb\u4dc2\ua66d\u4dff\u260a\u26b3\u4ddf\ua644\u49dc\u4dda\u4de7\u4df2\u3b4c\u4dfa\u2645\u4df4\u4de4\u4dce\ua65d\ua657\u4df2\u2700\u4dd7\u4dfa\u269f\u4df4\u2685\ua67d\ua671\u274b\u3618\u4dea\u2614\u4df4\u3d72\u4de5\u4dea\ua67a\u4dca\u2779\u4df3");

    protected InputStream openInput(String fileName) throws IOException {
        File file = new File(fileName);
        FileInputStream fileIn = new FileInputStream(file);
        BufferedInputStream bufIn = new BufferedInputStream(fileIn);
        return bufIn;
    }

    public synchronized void convert(String sourceName, String destName) throws JavaLayerException {
        this.convert(sourceName, destName, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void convert(InputStream sourceStream, String destName, ProgressListener progressListener, Decoder.Params decoderParams) throws JavaLayerException {
        if (progressListener == null) {
            progressListener = PrintWriterProgressListener.newStdOut(0);
        }
        try {
            int frame;
            if (!(sourceStream instanceof BufferedInputStream)) {
                sourceStream = new BufferedInputStream(sourceStream);
            }
            int frameCount = -1;
            if (sourceStream.markSupported()) {
                sourceStream.mark(-1);
                frameCount = this.countFrames(sourceStream);
                sourceStream.reset();
            }
            progressListener.converterUpdate(1, frameCount, 0);
            Obuffer output = null;
            Decoder decoder = new Decoder(decoderParams);
            Bitstream stream = new Bitstream(sourceStream);
            if (frameCount == -1) {
                frameCount = Integer.MAX_VALUE;
            }
            long startTime = System.currentTimeMillis();
            try {
                for (frame = 0; frame < frameCount; ++frame) {
                    try {
                        Obuffer decoderOutput;
                        Header header = stream.readFrame();
                        if (header == null) {
                            break;
                        }
                        progressListener.readFrame(frame, header);
                        if (output == null) {
                            int channels = header.mode() == 3 ? 1 : 2;
                            int freq = header.frequency();
                            output = new WaveFileObuffer(channels, freq, destName);
                            decoder.setOutputBuffer(output);
                        }
                        if ((decoderOutput = decoder.decodeFrame(header, stream)) != output) {
                            throw new InternalError("Output buffers are different.");
                        }
                        progressListener.decodedFrame(frame, header, output);
                        stream.closeFrame();
                        continue;
                    }
                    catch (Exception ex) {
                        boolean stop;
                        boolean bl = stop = !progressListener.converterException(ex);
                        if (!stop) continue;
                        throw new JavaLayerException(ex.getLocalizedMessage(), ex);
                    }
                }
            }
            finally {
                if (output != null) {
                    output.close();
                }
            }
            int time = (int)(System.currentTimeMillis() - startTime);
            progressListener.converterUpdate(2, time, frame);
        }
        catch (IOException ex) {
            throw new JavaLayerException(ex.getLocalizedMessage(), ex);
        }
    }

    public void convert(String sourceName, String destName, ProgressListener progressListener, Decoder.Params decoderParams) throws JavaLayerException {
        if (destName.length() == 0) {
            destName = null;
        }
        try {
            InputStream in = this.openInput(sourceName);
            this.convert(in, destName, progressListener, decoderParams);
            in.close();
        }
        catch (IOException ioe) {
            throw new JavaLayerException(ioe.getLocalizedMessage(), ioe);
        }
    }

    protected int countFrames(InputStream in) {
        return -1;
    }

    public synchronized void convert(String sourceName, String destName, ProgressListener progressListener) throws JavaLayerException {
        this.convert(sourceName, destName, progressListener, null);
    }

    public static class PrintWriterProgressListener
    implements ProgressListener {
        private PrintWriter pw;
        private int detailLevel;
        public static final int VERBOSE_DETAIL = 2;
        public static final int NO_DETAIL = 0;
        public static final int EXPERT_DETAIL = 1;
        public static final int DEBUG_DETAIL = 7;
        public static final int MAX_DETAIL = 10;
        private static final NMSLException \u795e\u8c15\u4e5f\u4e0d\u4f1a\u5b9e\u73b0 = new NMSLException("\u4ddf\u3eac\u4ddd\u4de8\u4604\u4dc4\u27ab\u4dc0\u3cc6\u4dfd\ua65a\ua693\u4df8\u4dc8\u3d2e\u2628\u4dd8\u4dc9\u4b27\u4dd7\u270b\u4dfe\u270f\u2793\u264a\u4de1\u2687\u4dd7\u4dd1\ua645\u268f\u2622\u279a\u26cd\u260a\u4dc7\u2672\u4dd4\u4de7");

        public static PrintWriterProgressListener newStdOut(int detail) {
            return new PrintWriterProgressListener(new PrintWriter(System.out, true), detail);
        }

        public boolean isDetail(int detail) {
            return this.detailLevel >= detail;
        }

        @Override
        public void parsedFrame(int frameNo, Header header) {
            if (frameNo == 0 && this.isDetail(2)) {
                String headerString = header.toString();
                this.pw.println("File is a " + headerString);
            } else if (this.isDetail(10)) {
                String headerString = header.toString();
                this.pw.println("Prased frame " + frameNo + ": " + headerString);
            }
        }

        public PrintWriterProgressListener(PrintWriter writer, int detailLevel) {
            this.pw = writer;
            this.detailLevel = detailLevel;
        }

        @Override
        public void readFrame(int frameNo, Header header) {
            if (frameNo == 0 && this.isDetail(2)) {
                String headerString = header.toString();
                this.pw.println("File is a " + headerString);
            } else if (this.isDetail(10)) {
                String headerString = header.toString();
                this.pw.println("Read frame " + frameNo + ": " + headerString);
            }
        }

        @Override
        public void decodedFrame(int frameNo, Header header, Obuffer o) {
            if (this.isDetail(10)) {
                String headerString = header.toString();
                this.pw.println("Decoded frame " + frameNo + ": " + headerString);
                this.pw.println("Output: " + o);
            } else if (this.isDetail(2)) {
                if (frameNo == 0) {
                    this.pw.print("Converting.");
                    this.pw.flush();
                }
                if (frameNo % 10 == 0) {
                    this.pw.print('.');
                    this.pw.flush();
                }
            }
        }

        @Override
        public void converterUpdate(int updateID, int param1, int param2) {
            if (this.isDetail(2)) {
                switch (updateID) {
                    case 2: {
                        if (param2 == 0) {
                            param2 = 1;
                        }
                        this.pw.println();
                        this.pw.println("Converted " + param2 + " frames in " + param1 + " ms (" + param1 / param2 + " ms per frame.)");
                    }
                }
            }
        }

        @Override
        public boolean converterException(Throwable t) {
            if (this.detailLevel > 0) {
                t.printStackTrace(this.pw);
                this.pw.flush();
            }
            return false;
        }
    }

    public static interface ProgressListener {
        public static final int UPDATE_CONVERT_COMPLETE = 2;
        public static final int UPDATE_FRAME_COUNT = 1;

        public void decodedFrame(int var1, Header var2, Obuffer var3);

        public void parsedFrame(int var1, Header var2);

        public boolean converterException(Throwable var1);

        public void converterUpdate(int var1, int var2, int var3);

        public void readFrame(int var1, Header var2);
    }
}

