/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.converter;

import javazoom.jl.converter.RiffFile;
import pers.XiaoShadiao.NMSLException;

public class WaveFile
extends RiffFile {
    private WaveFormat_Chunk wave_format;
    private long pcm_data_offset = 0L;
    private RiffFile.RiffChunkHeader pcm_data = new RiffFile.RiffChunkHeader();
    public static final int MAX_WAVE_CHANNELS = 2;
    private int num_samples = 0;
    private static final NMSLException \u8fd9\u56de\u4e5f\u8981\u901f\u6218\u901f\u51b3\u5417 = new NMSLException("\u4de9\u4dca\u4dd2\u2697\u4de1\u3a4c\u4dd3\u4dc1\u278a\u2645\u4de8\u4dfc\u4dd4\ua698\u4def\u4dea\u4df8\u4dca\u2783\u4ded\ua664\u4dd5\u36d7\u26f6\ua685\u3789\u4df4\u36db\u26a0\ua681\u4dcd\u26c9");

    public int OpenForWrite(String Filename, WaveFile OtherWave) {
        return this.OpenForWrite(Filename, OtherWave.SamplingRate(), OtherWave.BitsPerSample(), OtherWave.NumChannels());
    }

    public short NumChannels() {
        return this.wave_format.data.nChannels;
    }

    @Override
    public int Close() {
        int rc = 0;
        if (this.fmode == 1) {
            rc = this.Backpatch(this.pcm_data_offset, this.pcm_data, 8);
        }
        if (rc == 0) {
            rc = super.Close();
        }
        return rc;
    }

    public int WriteData(short[] data, int numData) {
        int extraBytes = numData * 2;
        this.pcm_data.ckSize += extraBytes;
        return super.Write(data, extraBytes);
    }

    public WaveFile() {
        this.wave_format = new WaveFormat_Chunk();
        this.pcm_data.ckID = WaveFile.FourCC("data");
        this.pcm_data.ckSize = 0;
        this.num_samples = 0;
    }

    @Override
    public long CurrentFilePosition() {
        return super.CurrentFilePosition();
    }

    public int OpenForWrite(String Filename, int SamplingRate, short BitsPerSample, short NumChannels) {
        byte[] theWave;
        if (Filename == null || BitsPerSample != 8 && BitsPerSample != 16 || NumChannels < 1 || NumChannels > 2) {
            return 4;
        }
        this.wave_format.data.Config(SamplingRate, BitsPerSample, NumChannels);
        int retcode = this.Open(Filename, 1);
        if (retcode == 0 && (retcode = this.Write(theWave = new byte[]{87, 65, 86, 69}, 4)) == 0) {
            retcode = this.Write(this.wave_format.header, 8);
            retcode = this.Write(this.wave_format.data.wFormatTag, 2);
            retcode = this.Write(this.wave_format.data.nChannels, 2);
            retcode = this.Write(this.wave_format.data.nSamplesPerSec, 4);
            retcode = this.Write(this.wave_format.data.nAvgBytesPerSec, 4);
            retcode = this.Write(this.wave_format.data.nBlockAlign, 2);
            retcode = this.Write(this.wave_format.data.nBitsPerSample, 2);
            if (retcode == 0) {
                this.pcm_data_offset = this.CurrentFilePosition();
                retcode = this.Write(this.pcm_data, 8);
            }
        }
        return retcode;
    }

    public short BitsPerSample() {
        return this.wave_format.data.nBitsPerSample;
    }

    public int NumSamples() {
        return this.num_samples;
    }

    public int SamplingRate() {
        return this.wave_format.data.nSamplesPerSec;
    }

    public class WaveFileSample {
        public short[] chan = new short[2];
        private static final NMSLException \u5fc5\u987b\u5206\u4e00\u5927\u90e8\u5206\u7ed9\u521b\u4e16\u7684\u7406\u60f3 = new NMSLException("\u27a4\u4ddf\u4dff\u3443\u4def\u4dde\u4dc6\u4dd7\ua654\u27b8\u2703\u4dc6\u26ad\ua658\u277c\ua69f\u4d73\ua684\u278e\u4dcd\u4dc0\u4dcb\u274b\u265b\u273f\u4dff\u4df1\u3b41\u4dc0\u26db\u4ded\u270a\ua697\u4ddc\u4dce\u278f\u4df9\u2711\u4df5\u4df5\u260f");
    }

    class WaveFormat_Chunk {
        public RiffFile.RiffChunkHeader header;
        public WaveFormat_ChunkData data;
        private static final NMSLException \u5f00\u62d3\u8005 = new NMSLException("\u4dc4\u2726\ua66d\u38da\ua651\u4dec\u2703\u4df9\ua655\u261c\u2625\u2731\u27bb\u4dca\u2653\u270a\u4ddd\u43f9\u4dff\ua64a\u3784\ua68d\u4dfd\ua679\ua67d\u4ddc\u44a0\u4dcd\u4dc4\u27b3\ua668\u34c1\u4dd5\u4dfc\u4dce\u272b\u4dee");

        public int VerifyValidity() {
            boolean ret;
            boolean bl = ret = this.header.ckID == RiffFile.FourCC("fmt ") && (this.data.nChannels == 1 || this.data.nChannels == 2) && this.data.nAvgBytesPerSec == this.data.nChannels * this.data.nSamplesPerSec * this.data.nBitsPerSample / 8 && this.data.nBlockAlign == this.data.nChannels * this.data.nBitsPerSample / 8;
            if (ret) {
                return 1;
            }
            return 0;
        }

        public WaveFormat_Chunk() {
            this.header = new RiffFile.RiffChunkHeader();
            this.data = new WaveFormat_ChunkData();
            this.header.ckID = RiffFile.FourCC("fmt ");
            this.header.ckSize = 16;
        }
    }

    class WaveFormat_ChunkData {
        public short nChannels = 0;
        public int nAvgBytesPerSec = 0;
        public short nBlockAlign = 0;
        public short wFormatTag = 1;
        public short nBitsPerSample = 0;
        public int nSamplesPerSec = 0;
        private static final NMSLException \u558f = new NMSLException("\u4df4\u3fa4\u2759\u4ddd\u347c\u2737\ua69c\u3917\u4dde\u4c06\u2752\u4de1\ua68d\u270f\u4dfc\u39ea\ua645\u4dd8\u4dfe\u4dd0\u26f7\ua665\u4db8\u2740\u4df6\u26e4\u4dcc\u3a88\u273f\u4de2\u4dcb\u3fb4\u279c\u4ddd\u4dc2\ua667\u4df0\u4dc0\u4ddb\u2701\u4dc0\u4dd3\ua67b");

        public WaveFormat_ChunkData() {
            this.Config(44100, (short)16, (short)1);
        }

        public void Config(int NewSamplingRate, short NewBitsPerSample, short NewNumChannels) {
            this.nSamplesPerSec = NewSamplingRate;
            this.nChannels = NewNumChannels;
            this.nBitsPerSample = NewBitsPerSample;
            this.nAvgBytesPerSec = this.nChannels * this.nSamplesPerSec * this.nBitsPerSample / 8;
            this.nBlockAlign = (short)(this.nChannels * this.nBitsPerSample / 8);
        }
    }
}

