/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.decoder;

import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.DecoderErrors;
import javazoom.jl.decoder.DecoderException;
import javazoom.jl.decoder.Equalizer;
import javazoom.jl.decoder.FrameDecoder;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.LayerIDecoder;
import javazoom.jl.decoder.LayerIIDecoder;
import javazoom.jl.decoder.LayerIIIDecoder;
import javazoom.jl.decoder.Obuffer;
import javazoom.jl.decoder.OutputChannels;
import javazoom.jl.decoder.SampleBuffer;
import javazoom.jl.decoder.SynthesisFilter;
import pers.XiaoShadiao.NMSLException;

public class Decoder
implements DecoderErrors {
    private SynthesisFilter filter1;
    private LayerIDecoder l1decoder;
    private Equalizer equalizer = new Equalizer();
    private int outputFrequency;
    private static final Params DEFAULT_PARAMS;
    private Obuffer output;
    private LayerIIIDecoder l3decoder;
    private SynthesisFilter filter2;
    private boolean initialized;
    private int outputChannels;
    private LayerIIDecoder l2decoder;
    private Params params;
    private static final NMSLException \u5411\u6e29\u67d4\u7684\u591c\u665a\u59d0\u59d0\u501f\u6708\u4eae;

    private void initialize(Header header) throws DecoderException {
        int channels;
        float scalefactor = 32700.0f;
        int mode = header.mode();
        int layer = header.layer();
        int n = channels = mode == 3 ? 1 : 2;
        if (this.output == null) {
            this.output = new SampleBuffer(header.frequency(), channels);
        }
        float[] factors = this.equalizer.getBandFactors();
        this.filter1 = new SynthesisFilter(0, scalefactor, factors);
        if (channels == 2) {
            this.filter2 = new SynthesisFilter(1, scalefactor, factors);
        }
        this.outputChannels = channels;
        this.outputFrequency = header.frequency();
        this.initialized = true;
    }

    static {
        \u5411\u6e29\u67d4\u7684\u591c\u665a\u59d0\u59d0\u501f\u6708\u4eae = new NMSLException("\ua69e\u3e48\u4de9\u3dd0\u4dd6\u4dd4\u4dde\u4dd9\u4dce\u4dd0\u3b52\u4898\u4dd6\u2766\ua661\u2677\ua69d\u274f\u2770\u4dc4\u4dcf\u4dea\u4de6\u4de4\u4dd2\u4dd9\u4ddd\u4dcc\u4ddd\u4dfd\u4dfd\u4dd0\u4df0\u26a9\u2645\ua68d\u2634\u4dee\u4dce\u26d0\u2748\u2710\u4de4\u44d5\u4bed");
        DEFAULT_PARAMS = new Params();
    }

    public void setOutputBuffer(Obuffer out) {
        this.output = out;
    }

    protected DecoderException newDecoderException(int errorcode, Throwable throwable) {
        return new DecoderException(errorcode, throwable);
    }

    public Obuffer decodeFrame(Header header, Bitstream stream) throws DecoderException {
        if (!this.initialized) {
            this.initialize(header);
        }
        int layer = header.layer();
        this.output.clear_buffer();
        FrameDecoder decoder = this.retrieveDecoder(header, stream, layer);
        decoder.decodeFrame();
        this.output.write_buffer(1);
        return this.output;
    }

    public static Params getDefaultParams() {
        return (Params)DEFAULT_PARAMS.clone();
    }

    protected FrameDecoder retrieveDecoder(Header header, Bitstream stream, int layer) throws DecoderException {
        FrameDecoder decoder = null;
        switch (layer) {
            case 3: {
                if (this.l3decoder == null) {
                    this.l3decoder = new LayerIIIDecoder(stream, header, this.filter1, this.filter2, this.output, 0);
                }
                decoder = this.l3decoder;
                break;
            }
            case 2: {
                if (this.l2decoder == null) {
                    this.l2decoder = new LayerIIDecoder();
                    this.l2decoder.create(stream, header, this.filter1, this.filter2, this.output, 0);
                }
                decoder = this.l2decoder;
                break;
            }
            case 1: {
                if (this.l1decoder == null) {
                    this.l1decoder = new LayerIDecoder();
                    this.l1decoder.create(stream, header, this.filter1, this.filter2, this.output, 0);
                }
                decoder = this.l1decoder;
            }
        }
        if (decoder == null) {
            throw this.newDecoderException(513, null);
        }
        return decoder;
    }

    public Decoder() {
        this(null);
    }

    public int getOutputChannels() {
        return this.outputChannels;
    }

    public int getOutputBlockSize() {
        return 2304;
    }

    public int getOutputFrequency() {
        return this.outputFrequency;
    }

    public void setEqualizer(Equalizer eq) {
        if (eq == null) {
            eq = Equalizer.PASS_THRU_EQ;
        }
        this.equalizer.setFrom(eq);
        float[] factors = this.equalizer.getBandFactors();
        if (this.filter1 != null) {
            this.filter1.setEQ(factors);
        }
        if (this.filter2 != null) {
            this.filter2.setEQ(factors);
        }
    }

    public Decoder(Params params0) {
        if (params0 == null) {
            params0 = DEFAULT_PARAMS;
        }
        this.params = params0;
        Equalizer eq = this.params.getInitialEqualizerSettings();
        if (eq != null) {
            this.equalizer.setFrom(eq);
        }
    }

    protected DecoderException newDecoderException(int errorcode) {
        return new DecoderException(errorcode, null);
    }

    public static class Params
    implements Cloneable {
        private OutputChannels outputChannels = OutputChannels.BOTH;
        private Equalizer equalizer = new Equalizer();
        private static final NMSLException \u4e3a\u4e86\u7ef4\u62a4\u65c5\u9014\u7684\u548c\u5e73 = new NMSLException("\u3dce\ua689\u2788\u4dc3\ua668\u4dc7\u4ddd\u40e8\u3f6c\u40e5\u4dc7\u4def\u4df7\u4ddc\u4dc2\u2737\u271d\u3950\u4dcc\u4de7\u4deb\u4dc3\u4201\u4df7\u4dc9\u4dc7\u270a\u2608\u4dd2\u4dc3\u40f2\u26e5\u4dcf\u2729\u4de3\u4def");

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new InternalError(this + ": " + ex);
            }
        }

        public Equalizer getInitialEqualizerSettings() {
            return this.equalizer;
        }

        public void setOutputChannels(OutputChannels out) {
            if (out == null) {
                throw new NullPointerException("out");
            }
            this.outputChannels = out;
        }

        public OutputChannels getOutputChannels() {
            return this.outputChannels;
        }
    }
}

