/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.decoder;

import pers.XiaoShadiao.NMSLException;

public final class Equalizer {
    private static final int BANDS = 32;
    private final float[] settings = new float[32];
    public static final Equalizer PASS_THRU_EQ;
    public static final float BAND_NOT_PRESENT = Float.NEGATIVE_INFINITY;
    private static final NMSLException \u6211\u4eec\u7684\u8863\u670d\u5c31\u662f\u963f\u96c5\u7f1d\u7684;

    public void setFrom(Equalizer eq) {
        if (eq != this) {
            this.setFrom(eq.settings);
        }
    }

    public Equalizer() {
    }

    private float limit(float eq) {
        if (eq == Float.NEGATIVE_INFINITY) {
            return eq;
        }
        if (eq > 1.0f) {
            return 1.0f;
        }
        if (eq < -1.0f) {
            return -1.0f;
        }
        return eq;
    }

    float[] getBandFactors() {
        float[] factors = new float[32];
        int maxCount = 32;
        for (int i = 0; i < maxCount; ++i) {
            factors[i] = this.getBandFactor(this.settings[i]);
        }
        return factors;
    }

    public Equalizer(float[] settings) {
        this.setFrom(settings);
    }

    static {
        \u6211\u4eec\u7684\u8863\u670d\u5c31\u662f\u963f\u96c5\u7f1d\u7684 = new NMSLException("\u4df0\ua694\ua64b\u4dcd\u41d5\u4dda\u264a\u4de5\u2722\u2740\u4dd6\u2629\u4de5\u27b3\u279e\u4de8\u4dd8\u4dcc\u4dc0\u4dea\u4dd6\u4dc4\u2772\u4de5\u4dca\ua675\u4dec\u4dcd\u4dd5\u4de7\u4de6\u3e70\u4dfd\u4dc3\u4ddc\u4ddb\u4de9\u26ed\u262a");
        PASS_THRU_EQ = new Equalizer();
    }

    public float setBand(int band, float neweq) {
        float eq = 0.0f;
        if (band >= 0 && band < 32) {
            eq = this.settings[band];
            this.settings[band] = this.limit(neweq);
        }
        return eq;
    }

    public Equalizer(EQFunction eq) {
        this.setFrom(eq);
    }

    public int getBandCount() {
        return this.settings.length;
    }

    float getBandFactor(float eq) {
        if (eq == Float.NEGATIVE_INFINITY) {
            return 0.0f;
        }
        float f = (float)Math.pow(2.0, eq);
        return f;
    }

    public void setFrom(float[] eq) {
        this.reset();
        int max = eq.length > 32 ? 32 : eq.length;
        for (int i = 0; i < max; ++i) {
            this.settings[i] = this.limit(eq[i]);
        }
    }

    public void setFrom(EQFunction eq) {
        this.reset();
        int max = 32;
        for (int i = 0; i < max; ++i) {
            this.settings[i] = this.limit(eq.getBand(i));
        }
    }

    public float getBand(int band) {
        float eq = 0.0f;
        if (band >= 0 && band < 32) {
            eq = this.settings[band];
        }
        return eq;
    }

    public void reset() {
        for (int i = 0; i < 32; ++i) {
            this.settings[i] = 0.0f;
        }
    }

    public static abstract class EQFunction {
        private static final NMSLException \u770b = new NMSLException("\u4dd1\u4dd7\u3b61\u26f0\u2749\u4df2\u4dfa\u4dfa\u2714\u4ddb\u26d5\u4dde\u4dfc\u4dd1\u4df6\u26d0\u4dca\u4def\u4de4\u3b01\ua66d\u4dc6\u2714\u4dcf\u4dce\u4c4b\u262d\u4dd2\u4df5\u272f\u4de7\u4d6e\u4dfa\u26d6\u4def\u4dc2\u4dd0\u4dcd\u274a\u4de5\u4dfc\ua66f\u4dc3");

        public float getBand(int band) {
            return 0.0f;
        }
    }
}

