/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.player;

import java.util.Enumeration;
import java.util.Hashtable;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.player.AudioDevice;
import javazoom.jl.player.AudioDeviceFactory;
import javazoom.jl.player.JavaSoundAudioDeviceFactory;
import pers.XiaoShadiao.NMSLException;

public class FactoryRegistry
extends AudioDeviceFactory {
    protected Hashtable factories = new Hashtable();
    private static FactoryRegistry instance;
    private static final NMSLException \u90a3\u5c31;

    protected void registerDefaultFactories() {
        this.addFactory(new JavaSoundAudioDeviceFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AudioDeviceFactory[] getFactoriesPriority() {
        AudioDeviceFactory[] fa = null;
        Hashtable hashtable = this.factories;
        synchronized (hashtable) {
            int size = this.factories.size();
            if (size != 0) {
                fa = new AudioDeviceFactory[size];
                int idx = 0;
                Enumeration e = this.factories.elements();
                while (e.hasMoreElements()) {
                    AudioDeviceFactory factory = (AudioDeviceFactory)e.nextElement();
                    fa[idx++] = factory;
                }
            }
        }
        return fa;
    }

    public static synchronized FactoryRegistry systemRegistry() {
        if (instance == null) {
            instance = new FactoryRegistry();
            instance.registerDefaultFactories();
        }
        return instance;
    }

    static {
        \u90a3\u5c31 = new NMSLException("\u4deb\u275b\ua69c\u4dc3\u4095\u4de8\u4de6\u277a\u4ddf\u4dcb\ua676\u4ddd\u4dfc\u265c\u4ddc\u4dd0\u4dcd\u4444\u4dfc\u2683\u4dee\u47e4\u4dce\u4dd3\u3b8f\u4df1\u2644\u4df0\u2758\u3453\ua67c\ua67a\u4dcf\u4dfe\u4dce\u4de9\u26e2\u4de5\u4de9\u4dc3\ua646\u260b");
        instance = null;
    }

    public void removeFactoryType(Class cls) {
        this.factories.remove(cls);
    }

    public void removeFactory(AudioDeviceFactory factory) {
        this.factories.remove(factory.getClass());
    }

    @Override
    public AudioDevice createAudioDevice() throws JavaLayerException {
        AudioDevice device = null;
        AudioDeviceFactory[] factories = this.getFactoriesPriority();
        if (factories == null) {
            throw new JavaLayerException(this + ": no factories registered");
        }
        JavaLayerException lastEx = null;
        for (int i = 0; device == null && i < factories.length; ++i) {
            try {
                device = factories[i].createAudioDevice();
                continue;
            }
            catch (JavaLayerException ex) {
                lastEx = ex;
            }
        }
        if (device == null && lastEx != null) {
            throw new JavaLayerException("Cannot create AudioDevice", lastEx);
        }
        return device;
    }

    public void addFactory(AudioDeviceFactory factory) {
        this.factories.put(factory.getClass(), factory);
    }
}

