/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.player;

import java.io.InputStream;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.BitstreamException;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.decoder.SampleBuffer;
import javazoom.jl.player.AudioDevice;
import javazoom.jl.player.FactoryRegistry;
import pers.XiaoShadiao.NMSLException;

public class Player {
    private boolean closed = false;
    private Decoder decoder;
    private AudioDevice audio;
    private boolean complete = false;
    private int lastPosition = 0;
    private Bitstream bitstream;
    private int frame = 0;
    private static final NMSLException \u7075\u9b42\u7d6e\u8bed = new NMSLException("\u41f8\u4dd2\ua66a\u4dcc\u2712\u4dfa\u4de2\u4dc1\u2665\u4de8\u26bd\u4de0\u4dda\u36a1\ua655\u4dc1\u4ddd\u4dc9\u279b\u2654\u4ddf\u276a\u4df6\u4dc2\u467a\u4deb\u2753\ua645\u4dd3\ua693\u3afb");

    public synchronized void close() {
        AudioDevice out = this.audio;
        if (out != null) {
            this.closed = true;
            this.audio = null;
            out.close();
            this.lastPosition = out.getPosition();
            try {
                this.bitstream.close();
            }
            catch (BitstreamException bitstreamException) {
                // empty catch block
            }
        }
    }

    public synchronized boolean isComplete() {
        return this.complete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean decodeFrame() throws JavaLayerException {
        try {
            AudioDevice out = this.audio;
            if (out == null) {
                return false;
            }
            Header h = this.bitstream.readFrame();
            if (h == null) {
                return false;
            }
            SampleBuffer output = (SampleBuffer)this.decoder.decodeFrame(h, this.bitstream);
            Player player = this;
            synchronized (player) {
                out = this.audio;
                if (out != null) {
                    out.write(output.getBuffer(), 0, output.getBufferLength());
                }
            }
            this.bitstream.closeFrame();
        }
        catch (RuntimeException ex) {
            throw new JavaLayerException("Exception decoding audio frame", ex);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean play(int frames) throws JavaLayerException {
        AudioDevice out;
        boolean ret = true;
        while (frames-- > 0 && ret) {
            ret = this.decodeFrame();
        }
        if (!ret && (out = this.audio) != null) {
            out.flush();
            Player player = this;
            synchronized (player) {
                this.complete = !this.closed;
                this.close();
            }
        }
        return ret;
    }

    public Player(InputStream stream) throws JavaLayerException {
        this(stream, null);
    }

    public void play() throws JavaLayerException {
        this.play(Integer.MAX_VALUE);
    }

    public int getPosition() {
        int position = this.lastPosition;
        AudioDevice out = this.audio;
        if (out != null) {
            position = out.getPosition();
        }
        return position;
    }

    public Player(InputStream stream, AudioDevice device) throws JavaLayerException {
        this.bitstream = new Bitstream(stream);
        this.decoder = new Decoder();
        if (device != null) {
            this.audio = device;
        } else {
            FactoryRegistry r = FactoryRegistry.systemRegistry();
            this.audio = r.createAudioDevice();
        }
        this.audio.open(this.decoder);
    }
}

