/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.player;

import java.applet.Applet;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.player.AudioDevice;
import javazoom.jl.player.FactoryRegistry;
import javazoom.jl.player.Player;
import pers.XiaoShadiao.NMSLException;

public class PlayerApplet
extends Applet
implements Runnable {
    public static final String AUDIO_PARAMETER = "audioURL";
    private Thread playerThread = null;
    private String fileName = null;
    private Player player = null;
    private static final NMSLException \u63a8\u5f00\u95e8\u5427 = new NMSLException("\u4ddc\u4ddd\ua689\u4dc5\u45d4\u26ef\u4dc2\u379f\ua64a\u2716\u4dfc\u4ddd\u4dea\u46a9\u4c74\u4dd8\u37bb\u4dea\u2603\u4dfb\u4ddf\u4df6\u2787\u4dc4\ua691\u3a1d\u4df6\u3930\u2782\u4dc8\u3bd4\u2637\u4dff\u4de0\u4df5\u46ae\u3900\u4dfe\u2612\u4df5\u2660\u351d\u266a\u2732\u2743\u4dc5\u4ded\u271c");

    @Override
    public void init() {
    }

    protected InputStream getAudioStream() {
        InputStream in = null;
        try {
            URL url = this.getAudioURL();
            if (url != null) {
                in = url.openStream();
            }
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
        return in;
    }

    public String getFileName() {
        return this.fileName;
    }

    protected AudioDevice getAudioDevice() throws JavaLayerException {
        return FactoryRegistry.systemRegistry().createAudioDevice();
    }

    protected URL getAudioURL() {
        String urlString = this.getAudioFileName();
        URL url = null;
        if (urlString != null) {
            try {
                url = new URL(this.getDocumentBase(), urlString);
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
        }
        return url;
    }

    protected void stopPlayer() throws JavaLayerException {
        if (this.player != null) {
            this.player.close();
            this.player = null;
            this.playerThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        String name = this.getAudioFileName();
        try {
            InputStream in = this.getAudioStream();
            AudioDevice dev = this.getAudioDevice();
            this.play(in, dev);
        }
        catch (JavaLayerException ex) {
            PrintStream printStream = System.err;
            synchronized (printStream) {
                System.err.println("Unable to play " + name);
                ex.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void stop() {
        try {
            this.stopPlayer();
        }
        catch (JavaLayerException ex) {
            System.err.println(ex);
        }
    }

    protected Thread createPlayerThread() {
        return new Thread((Runnable)this, "Audio player thread");
    }

    public void setFileName(String name) {
        this.fileName = name;
    }

    protected String getAudioFileName() {
        String urlString = this.fileName;
        if (urlString == null) {
            urlString = this.getParameter(AUDIO_PARAMETER);
        }
        return urlString;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void run() {
        if (this.player != null) {
            try {
                this.player.play();
            }
            catch (JavaLayerException ex) {
                System.err.println("Problem playing audio: " + ex);
            }
        }
    }

    protected void play(InputStream in, AudioDevice dev) throws JavaLayerException {
        this.stopPlayer();
        if (in != null && dev != null) {
            this.player = new Player(in, dev);
            this.playerThread = this.createPlayerThread();
            this.playerThread.start();
        }
    }
}

