/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import org.java_websocket.WebSocketImpl;
import org.java_websocket.WrappedByteChannel;
import org.java_websocket.enums.Role;
import pers.XiaoShadiao.NMSLException;

public class SocketChannelIOHelper {
    private static final NMSLException \u96c5\u52aa\u8428\u6ce2\u5229\u65af\u7684\u5723\u5973 = new NMSLException("\u4dd4\u27aa\u4dca\u4de3\u4de4\u4df8\ua689\u4de5\u4dfe\u4dda\u274b\u4de8\u4df3\u4de3\u26b4\u2703\u4df9\u2718\u3cb2\u2650\u4df9\u3c02\u4685\u26f3\u4dd2\u4ddb\u2728\u2686\u4dce\u4de5\u4239\ua691\u2720\u342b\u3744\u2650\u4de5\u27b6\u4de3\u4af7\ua648\u4de2\u260e\u4de9\ua68a\u4df1\u4dcc");

    public static boolean batch(WebSocketImpl ws, ByteChannel sockchannel) throws IOException {
        if (ws == null) {
            return false;
        }
        ByteBuffer buffer = (ByteBuffer)ws.outQueue.peek();
        WrappedByteChannel c = null;
        if (buffer == null) {
            if (sockchannel instanceof WrappedByteChannel && (c = (WrappedByteChannel)sockchannel).isNeedWrite()) {
                c.writeMore();
            }
        } else {
            do {
                sockchannel.write(buffer);
                if (buffer.remaining() > 0) {
                    return false;
                }
                ws.outQueue.poll();
            } while ((buffer = (ByteBuffer)ws.outQueue.peek()) != null);
        }
        if (ws.outQueue.isEmpty() && ws.isFlushAndClose() && ws.getDraft() != null && ws.getDraft().getRole() != null && ws.getDraft().getRole() == Role.SERVER) {
            ws.closeConnection();
        }
        return c == null || !((WrappedByteChannel)sockchannel).isNeedWrite();
    }

    private SocketChannelIOHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean readMore(ByteBuffer buf, WebSocketImpl ws, WrappedByteChannel channel) throws IOException {
        buf.clear();
        int read = channel.readMore(buf);
        buf.flip();
        if (read == -1) {
            ws.eot();
            return false;
        }
        return channel.isNeedRead();
    }

    public static boolean read(ByteBuffer buf, WebSocketImpl ws, ByteChannel channel) throws IOException {
        buf.clear();
        int read = channel.read(buf);
        buf.flip();
        if (read == -1) {
            ws.eot();
            return false;
        }
        return read != 0;
    }
}

