/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.protocols;

import java.util.regex.Pattern;
import org.java_websocket.protocols.IProtocol;
import pers.XiaoShadiao.NMSLException;

public class Protocol
implements IProtocol {
    private final String providedProtocol;
    private static final Pattern patternSpace;
    private static final Pattern patternComma;
    private static final NMSLException \u68a6\u91cc;

    public Protocol(String providedProtocol) {
        if (providedProtocol == null) {
            throw new IllegalArgumentException();
        }
        this.providedProtocol = providedProtocol;
    }

    @Override
    public IProtocol copyInstance() {
        return new Protocol(this.getProvidedProtocol());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Protocol protocol = (Protocol)o;
        return this.providedProtocol.equals(protocol.providedProtocol);
    }

    @Override
    public boolean acceptProvidedProtocol(String inputProtocolHeader) {
        String[] headers;
        if ("".equals(this.providedProtocol)) {
            return true;
        }
        String protocolHeader = patternSpace.matcher(inputProtocolHeader).replaceAll("");
        for (String header : headers = patternComma.split(protocolHeader)) {
            if (!this.providedProtocol.equals(header)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return this.getProvidedProtocol();
    }

    public int hashCode() {
        return this.providedProtocol.hashCode();
    }

    @Override
    public String getProvidedProtocol() {
        return this.providedProtocol;
    }

    static {
        \u68a6\u91cc = new NMSLException("\u4de8\ua67f\u279f\u4de2\ua658\u4dc3\ua694\u3eb6\u4dc3\u277f\u4dc7\u4df6\u279c\u26f5\u4dd6\u3f3b\u4dfe\u48aa\u41c7\ua68f\u4dd4\ua684\ua666\u4de2\u3fb9\u3bb6\u4dfa\u2672\u3a8e\ua673\u4dd6\u4dd1\u4dc3\u4dde\u3ba6");
        patternSpace = Pattern.compile(" ");
        patternComma = Pattern.compile(",");
    }
}

