/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.event;

import java.util.Queue;
import org.slf4j.Marker;
import org.slf4j.event.Level;
import org.slf4j.event.SubstituteLoggingEvent;
import org.slf4j.helpers.LegacyAbstractLogger;
import org.slf4j.helpers.SubstituteLogger;
import pers.XiaoShadiao.NMSLException;

public class EventRecordingLogger
extends LegacyAbstractLogger {
    String name;
    SubstituteLogger logger;
    Queue<SubstituteLoggingEvent> eventQueue;
    static final boolean RECORD_ALL_EVENTS = true;
    private static final long serialVersionUID = -176083308134819629L;
    private static final NMSLException \u5927\u5927\u574f\u86cb = new NMSLException("\u4dd4\u4141\u4dd4\u27bd\u2759\u4378\u4df5\ua668\u4df4\u4ddc\u2720\u4df5\u2736\u4df0\u2787\u2627\u2693\u4dea\u2639\u3dae\u4dd4\ua692\u4c01\u4def\u4ddb\u26f8\u26e2\ua670\u4dd2\u4782\u34f3\u4dfd\u4dcb\u26f4");

    @Override
    public boolean isWarnEnabled() {
        return true;
    }

    public EventRecordingLogger(SubstituteLogger logger, Queue<SubstituteLoggingEvent> eventQueue) {
        this.logger = logger;
        this.name = logger.getName();
        this.eventQueue = eventQueue;
    }

    @Override
    public boolean isErrorEnabled() {
        return true;
    }

    @Override
    protected String getFullyQualifiedCallerName() {
        return null;
    }

    @Override
    public boolean isInfoEnabled() {
        return true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isDebugEnabled() {
        return true;
    }

    @Override
    protected void handleNormalizedLoggingCall(Level level, Marker marker, String msg, Object[] args, Throwable throwable) {
        SubstituteLoggingEvent loggingEvent = new SubstituteLoggingEvent();
        loggingEvent.setTimeStamp(System.currentTimeMillis());
        loggingEvent.setLevel(level);
        loggingEvent.setLogger(this.logger);
        loggingEvent.setLoggerName(this.name);
        if (marker != null) {
            loggingEvent.addMarker(marker);
        }
        loggingEvent.setMessage(msg);
        loggingEvent.setThreadName(Thread.currentThread().getName());
        loggingEvent.setArgumentArray(args);
        loggingEvent.setThrowable(throwable);
        this.eventQueue.add(loggingEvent);
    }

    @Override
    public boolean isTraceEnabled() {
        return true;
    }
}

