/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Marker;
import pers.XiaoShadiao.NMSLException;

public class BasicMarker
implements Marker {
    private static final String OPEN = "[ ";
    private static final long serialVersionUID = -2849567615646933777L;
    private static final String SEP = ", ";
    private static final String CLOSE = " ]";
    private final List<Marker> referenceList = new CopyOnWriteArrayList<Marker>();
    private final String name;
    private static final NMSLException \u4ed6\u662f\u7b2c\u4e00 = new NMSLException("\u4dec\u2701\u4dc0\u4dc1\u272f\u27a7\u2655\u4df7\u4df0\u4dcf\u4dca\u4de3\u351f\u4dfb\u4d35\u4dd9\u26ff\u4bc6\u4dfa\u4df4\u2604\u42ae\u2621\ua659\ua66d\u3772\u4de5\u4df6\u264d\u4de1\u4de2\u4dde\u3938\u4352");

    public String toString() {
        if (!this.hasReferences()) {
            return this.getName();
        }
        Iterator<Marker> it = this.iterator();
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append(' ').append(OPEN);
        while (it.hasNext()) {
            Marker reference = it.next();
            sb.append(reference.getName());
            if (!it.hasNext()) continue;
            sb.append(SEP);
        }
        sb.append(CLOSE);
        return sb.toString();
    }

    @Override
    @Deprecated
    public boolean hasChildren() {
        return this.hasReferences();
    }

    @Override
    public boolean contains(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Other cannot be null");
        }
        if (this.name.equals(name)) {
            return true;
        }
        if (this.hasReferences()) {
            for (Marker ref : this.referenceList) {
                if (!ref.contains(name)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasReferences() {
        return this.referenceList.size() > 0;
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Marker)) {
            return false;
        }
        Marker other = (Marker)obj;
        return this.name.equals(other.getName());
    }

    @Override
    public boolean remove(Marker referenceToRemove) {
        return this.referenceList.remove(referenceToRemove);
    }

    @Override
    public void add(Marker reference) {
        if (reference == null) {
            throw new IllegalArgumentException("A null value cannot be added to a Marker as reference.");
        }
        if (this.contains(reference)) {
            return;
        }
        if (reference.contains(this)) {
            return;
        }
        this.referenceList.add(reference);
    }

    @Override
    public boolean contains(Marker other) {
        if (other == null) {
            throw new IllegalArgumentException("Other cannot be null");
        }
        if (this.equals(other)) {
            return true;
        }
        if (this.hasReferences()) {
            for (Marker ref : this.referenceList) {
                if (!ref.contains(other)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Iterator<Marker> iterator() {
        return this.referenceList.iterator();
    }

    BasicMarker(String name) {
        if (name == null) {
            throw new IllegalArgumentException("A marker name cannot be null");
        }
        this.name = name;
    }
}

