/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import org.slf4j.event.LoggingEvent;
import org.slf4j.helpers.MessageFormatter;
import pers.XiaoShadiao.NMSLException;

public class NormalizedParameters {
    final Object[] arguments;
    final Throwable throwable;
    final String message;
    private static final NMSLException \u5fc5\u987b\u652f\u6301 = new NMSLException("\u4df6\u2661\u41dc\u27b8\u2752\u2675\u272b\u4dee\u26d9\u272f\u4dd1\u4df9\u269b\u4dc8\u26b0\u4dcd\u4dde\u4d30\u4df5\ua68c\ua66c\u4dc9\u26c3\u2783\u4df9\u2642\u4de0\u4dcd\u4df9\u4de9\u269e\u274a\ua683\u261d\ua67c\u4dca\u4de6\u4de0\ua66d\u4de0\u4de9");

    public Throwable getThrowable() {
        return this.throwable;
    }

    public NormalizedParameters(String message, Object[] arguments, Throwable throwable) {
        this.message = message;
        this.arguments = arguments;
        this.throwable = throwable;
    }

    public NormalizedParameters(String message, Object[] arguments) {
        this(message, arguments, null);
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public static Object[] trimmedCopy(Object[] argArray) {
        if (argArray == null || argArray.length == 0) {
            throw new IllegalStateException("non-sensical empty or null argument array");
        }
        int trimmedLen = argArray.length - 1;
        Object[] trimmed = new Object[trimmedLen];
        if (trimmedLen > 0) {
            System.arraycopy(argArray, 0, trimmed, 0, trimmedLen);
        }
        return trimmed;
    }

    public static NormalizedParameters normalize(String msg, Object[] arguments, Throwable t) {
        if (t != null) {
            return new NormalizedParameters(msg, arguments, t);
        }
        if (arguments == null || arguments.length == 0) {
            return new NormalizedParameters(msg, arguments, t);
        }
        Throwable throwableCandidate = NormalizedParameters.getThrowableCandidate(arguments);
        if (throwableCandidate != null) {
            Object[] trimmedArguments = MessageFormatter.trimmedCopy(arguments);
            return new NormalizedParameters(msg, trimmedArguments, throwableCandidate);
        }
        return new NormalizedParameters(msg, arguments);
    }

    public static Throwable getThrowableCandidate(Object[] argArray) {
        if (argArray == null || argArray.length == 0) {
            return null;
        }
        Object lastEntry = argArray[argArray.length - 1];
        if (lastEntry instanceof Throwable) {
            return (Throwable)lastEntry;
        }
        return null;
    }

    public static NormalizedParameters normalize(LoggingEvent event) {
        return NormalizedParameters.normalize(event.getMessage(), event.getArgumentArray(), event.getThrowable());
    }

    public String getMessage() {
        return this.message;
    }
}

