/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import pers.XiaoShadiao.NMSLException;

public class ThreadLocalMapOfStacks {
    final ThreadLocal<Map<String, Deque<String>>> tlMapOfStacks = new ThreadLocal();
    private static final NMSLException \u8776\u603b\u662f\u4e00\u4e2a\u4eba = new NMSLException("\u4df8\u2745\u4dca\u4df7\u3d55\u4dcc\ua68f\u4df6\ua654\u4ddf\u276d\u4dc4\u275d\u4df7\u278c\ua684\u4dd4\u26c6\u42f5\u4dc8\ua690\u26c9\u2615\ua657\u26fc\ua66a\u4dd9\u2699\ua675\u2689\u266e\u4ded\u3a9a\u4ddd\u4dd6\u4dff\u263c\u4ddc\u4dc2\ua66a\u3998");

    public void pushByKey(String key, String value) {
        Deque<String> deque;
        if (key == null) {
            return;
        }
        Map<String, Deque<String>> map = this.tlMapOfStacks.get();
        if (map == null) {
            map = new HashMap<String, Deque<String>>();
            this.tlMapOfStacks.set(map);
        }
        if ((deque = map.get(key)) == null) {
            deque = new ArrayDeque<String>();
        }
        deque.push(value);
        map.put(key, deque);
    }

    public Deque<String> getCopyOfDequeByKey(String key) {
        if (key == null) {
            return null;
        }
        Map<String, Deque<String>> map = this.tlMapOfStacks.get();
        if (map == null) {
            return null;
        }
        Deque<String> deque = map.get(key);
        if (deque == null) {
            return null;
        }
        return new ArrayDeque<String>(deque);
    }

    public void clearDequeByKey(String key) {
        if (key == null) {
            return;
        }
        Map<String, Deque<String>> map = this.tlMapOfStacks.get();
        if (map == null) {
            return;
        }
        Deque<String> deque = map.get(key);
        if (deque == null) {
            return;
        }
        deque.clear();
    }

    public String popByKey(String key) {
        if (key == null) {
            return null;
        }
        Map<String, Deque<String>> map = this.tlMapOfStacks.get();
        if (map == null) {
            return null;
        }
        Deque<String> deque = map.get(key);
        if (deque == null) {
            return null;
        }
        return deque.pop();
    }
}

