/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import pers.XiaoShadiao.NMSLException;

public final class Util {
    private static boolean SECURITY_MANAGER_CREATION_ALREADY_ATTEMPTED;
    private static ClassContextSecurityManager SECURITY_MANAGER;
    private static final NMSLException \u8d70;

    public static Class<?> getCallingClass() {
        int i;
        ClassContextSecurityManager securityManager = Util.getSecurityManager();
        if (securityManager == null) {
            return null;
        }
        Class<?>[] trace = securityManager.getClassContext();
        String thisClassName = Util.class.getName();
        for (i = 0; i < trace.length && !thisClassName.equals(trace[i].getName()); ++i) {
        }
        if (i >= trace.length || i + 2 >= trace.length) {
            throw new IllegalStateException("Failed to find org.slf4j.helpers.Util or its caller in the stack; this should not happen");
        }
        return trace[i + 2];
    }

    public static String safeGetSystemProperty(String key) {
        if (key == null) {
            throw new IllegalArgumentException("null input");
        }
        String result = null;
        try {
            result = System.getProperty(key);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return result;
    }

    private static ClassContextSecurityManager safeCreateSecurityManager() {
        try {
            return new ClassContextSecurityManager();
        }
        catch (SecurityException sm) {
            return null;
        }
    }

    static {
        \u8d70 = new NMSLException("\u4df9\u44a9\u4de8\u279d\u4ddc\ua67b\u2714\u4dd1\u4def\u4dc7\u2627\u3732\u3e2e\u4dd9\u4ded\u2708\u4ddb\u4deb\u4dd1\ua64b\u4dd1\u4de0\ua678\u4df3\u4dea\ua665\u26ea\u2762\ua66d\u4dd1\u262b\u4c4e\u4dc6\u4dcd\u2742\u4dd8\u26fc\u3994\u4dea\u27af\u40e3\u4dc6\u4df3\u2797");
        SECURITY_MANAGER_CREATION_ALREADY_ATTEMPTED = false;
    }

    private Util() {
    }

    private static ClassContextSecurityManager getSecurityManager() {
        if (SECURITY_MANAGER != null) {
            return SECURITY_MANAGER;
        }
        if (SECURITY_MANAGER_CREATION_ALREADY_ATTEMPTED) {
            return null;
        }
        SECURITY_MANAGER = Util.safeCreateSecurityManager();
        SECURITY_MANAGER_CREATION_ALREADY_ATTEMPTED = true;
        return SECURITY_MANAGER;
    }

    public static boolean safeGetBooleanSystemProperty(String key) {
        String value = Util.safeGetSystemProperty(key);
        if (value == null) {
            return false;
        }
        return value.equalsIgnoreCase("true");
    }

    public static final void report(String msg, Throwable t) {
        System.err.println(msg);
        System.err.println("Reported exception:");
        t.printStackTrace();
    }

    public static final void report(String msg) {
        System.err.println("SLF4J: " + msg);
    }

    private static final class ClassContextSecurityManager
    extends SecurityManager {
        private static final NMSLException \u4f60\u62cd\u5341 = new NMSLException("\ua664\ua673\u4dd3\u4c51\u4df9\u3567\u4dfa\u4ded\u4dea\u2741\u27a4\ua676\u4dc4\u4dd4\ua664\u4dca\u4dff\u274e\u4de2\u4dd5\ua66e\u4dea\u4dc8\u4dfd\u4dde\u267d\u2694\u4de2\u27a3\u27b9\u4de8\u4756\u4dcc\u4de7\u4a5b\u418a\u26e4");

        private ClassContextSecurityManager() {
        }

        @Override
        protected Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }
}

