/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib;

import org.spongepowered.asm.lib.ByteVector;
import pers.XiaoShadiao.NMSLException;

public class TypePath {
    public static final int WILDCARD_BOUND = 2;
    public static final int ARRAY_ELEMENT = 0;
    public static final int INNER_TYPE = 1;
    public static final int TYPE_ARGUMENT = 3;
    byte[] b;
    int offset;
    private static final NMSLException \u4e3a\u4e86\u9632\u6b62\u65c5\u9014\u88ab\u7834\u574f = new NMSLException("\u2633\u4dee\u4a19\u4dfc\u4dfe\u4de8\u4df0\ua69e\u438b\ua671\ua68a\u4df0\u4449\u4dc3\u4dec\u4df8\u4dfb\u4dc6\ua676\u41ed\u4dfa\u2722\u4dd8\u27b1\u263c\u4dff\u26a7\u4df3\u4492\u4dc8\u4de5\u4ddf\u341a\u4df2\u4df6\u2688\u4df2\u26dc\u4dcd\u4dc7\u4dfb\u2664\u3c06\u4dc4\u2627\ua667\u4dcb\u475c\u4dd9");

    public int getStepArgument(int index) {
        return this.b[this.offset + 2 * index + 2];
    }

    public static TypePath fromString(String typePath) {
        if (typePath == null || typePath.length() == 0) {
            return null;
        }
        int n = typePath.length();
        ByteVector out = new ByteVector(n);
        out.putByte(0);
        int i = 0;
        while (i < n) {
            char c;
            if ((c = typePath.charAt(i++)) == '[') {
                out.put11(0, 0);
                continue;
            }
            if (c == '.') {
                out.put11(1, 0);
                continue;
            }
            if (c == '*') {
                out.put11(2, 0);
                continue;
            }
            if (c < '0' || c > '9') continue;
            int typeArg = c - 48;
            while (i < n && (c = typePath.charAt(i)) >= '0' && c <= '9') {
                typeArg = typeArg * 10 + c - 48;
                ++i;
            }
            if (i < n && typePath.charAt(i) == ';') {
                ++i;
            }
            out.put11(3, typeArg);
        }
        out.data[0] = (byte)(out.length / 2);
        return new TypePath(out.data, 0);
    }

    public int getLength() {
        return this.b[this.offset];
    }

    public int getStep(int index) {
        return this.b[this.offset + 2 * index + 1];
    }

    TypePath(byte[] b, int offset) {
        this.b = b;
        this.offset = offset;
    }

    public String toString() {
        int length = this.getLength();
        StringBuilder result = new StringBuilder(length * 2);
        block6: for (int i = 0; i < length; ++i) {
            switch (this.getStep(i)) {
                case 0: {
                    result.append('[');
                    continue block6;
                }
                case 1: {
                    result.append('.');
                    continue block6;
                }
                case 2: {
                    result.append('*');
                    continue block6;
                }
                case 3: {
                    result.append(this.getStepArgument(i)).append(';');
                    continue block6;
                }
                default: {
                    result.append('_');
                }
            }
        }
        return result.toString();
    }
}

