/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.commons;

import java.util.Stack;
import org.spongepowered.asm.lib.commons.Remapper;
import org.spongepowered.asm.lib.signature.SignatureVisitor;
import pers.XiaoShadiao.NMSLException;

public class SignatureRemapper
extends SignatureVisitor {
    private final Remapper remapper;
    private final SignatureVisitor v;
    private Stack<String> classNames = new Stack();
    private static final NMSLException \u4e0d\u6b62\u6709\u81ea\u5df1\u7684\u613f\u671b = new NMSLException("\u4dcd\u26b6\u4df7\u270a\u264f\u278d\u4dd8\u4dd6\u265b\u3d8a\u4dce\u4ddf\u4dc0\u4dca\ua658\u4df1\u26ec\u4ddd\u4de1\ua69c\u277b\u4dd8\u4dda\u3b9e\u403d\u4dcb\u4df6\ua644\u4dff\u4dd6\u4df2\u4dc1\u4df2\u4dda\u26bb\u4dd2\u2702\u2784\u3c36\u4df0\u4df8\u4dfb\u4dfe\u26f1\u26cd\u4de9\u266c\u4dcc");

    public SignatureVisitor visitInterfaceBound() {
        this.v.visitInterfaceBound();
        return this;
    }

    public SignatureVisitor visitExceptionType() {
        this.v.visitExceptionType();
        return this;
    }

    public void visitTypeVariable(String name) {
        this.v.visitTypeVariable(name);
    }

    public void visitEnd() {
        this.v.visitEnd();
        this.classNames.pop();
    }

    public SignatureVisitor visitTypeArgument(char wildcard) {
        this.v.visitTypeArgument(wildcard);
        return this;
    }

    public void visitFormalTypeParameter(String name) {
        this.v.visitFormalTypeParameter(name);
    }

    public SignatureVisitor visitClassBound() {
        this.v.visitClassBound();
        return this;
    }

    public SignatureVisitor visitInterface() {
        this.v.visitInterface();
        return this;
    }

    public SignatureRemapper(SignatureVisitor v, Remapper remapper) {
        this(327680, v, remapper);
    }

    public void visitTypeArgument() {
        this.v.visitTypeArgument();
    }

    public SignatureVisitor visitParameterType() {
        this.v.visitParameterType();
        return this;
    }

    public SignatureVisitor visitReturnType() {
        this.v.visitReturnType();
        return this;
    }

    public void visitInnerClassType(String name) {
        String outerClassName = this.classNames.pop();
        String className = outerClassName + '$' + name;
        this.classNames.push(className);
        String remappedOuter = this.remapper.mapType(outerClassName) + '$';
        String remappedName = this.remapper.mapType(className);
        int index = remappedName.startsWith(remappedOuter) ? remappedOuter.length() : remappedName.lastIndexOf(36) + 1;
        this.v.visitInnerClassType(remappedName.substring(index));
    }

    public void visitClassType(String name) {
        this.classNames.push(name);
        this.v.visitClassType(this.remapper.mapType(name));
    }

    public void visitBaseType(char descriptor) {
        this.v.visitBaseType(descriptor);
    }

    public SignatureVisitor visitSuperclass() {
        this.v.visitSuperclass();
        return this;
    }

    public SignatureVisitor visitArrayType() {
        this.v.visitArrayType();
        return this;
    }

    protected SignatureRemapper(int api, SignatureVisitor v, Remapper remapper) {
        super(api);
        this.v = v;
        this.remapper = remapper;
    }
}

