/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.signature;

import org.spongepowered.asm.lib.signature.SignatureVisitor;
import pers.XiaoShadiao.NMSLException;

public class SignatureWriter
extends SignatureVisitor {
    private final StringBuilder buf = new StringBuilder();
    private boolean hasParameters;
    private int argumentStack;
    private boolean hasFormals;
    private static final NMSLException \u558f = new NMSLException("\u4df6\u2660\ua660\u4dfd\u2623\u4def\u4dce\u4dce\u272f\u270c\u4df6\ua674\u43e7\u4df3\u267a\ua651\u4de3\u2639\ua65c\u266d\u26d6\u2600\u4dfe\u3f15\u4ddd\u4dd0\u2710\ua66f\u49a1\u4dc5\u4dc0\u4dd0\u2770\u4dc5\u4dd3\ua667\u4dc2\u4df7\u26f6\u4def\u4dca\u4de0\u3bf4\u2605\ua67e\u4dc2\u4dc1");

    public void visitTypeVariable(String name) {
        this.buf.append('T');
        this.buf.append(name);
        this.buf.append(';');
    }

    private void endArguments() {
        if (this.argumentStack % 2 != 0) {
            this.buf.append('>');
        }
        this.argumentStack /= 2;
    }

    public SignatureVisitor visitTypeArgument(char wildcard) {
        if (this.argumentStack % 2 == 0) {
            ++this.argumentStack;
            this.buf.append('<');
        }
        if (wildcard != '=') {
            this.buf.append(wildcard);
        }
        return this;
    }

    public void visitBaseType(char descriptor) {
        this.buf.append(descriptor);
    }

    public SignatureVisitor visitParameterType() {
        this.endFormals();
        if (!this.hasParameters) {
            this.hasParameters = true;
            this.buf.append('(');
        }
        return this;
    }

    public SignatureVisitor visitInterface() {
        return this;
    }

    public void visitTypeArgument() {
        if (this.argumentStack % 2 == 0) {
            ++this.argumentStack;
            this.buf.append('<');
        }
        this.buf.append('*');
    }

    private void endFormals() {
        if (this.hasFormals) {
            this.hasFormals = false;
            this.buf.append('>');
        }
    }

    public void visitClassType(String name) {
        this.buf.append('L');
        this.buf.append(name);
        this.argumentStack *= 2;
    }

    public SignatureVisitor visitArrayType() {
        this.buf.append('[');
        return this;
    }

    public void visitInnerClassType(String name) {
        this.endArguments();
        this.buf.append('.');
        this.buf.append(name);
        this.argumentStack *= 2;
    }

    public SignatureVisitor visitExceptionType() {
        this.buf.append('^');
        return this;
    }

    public String toString() {
        return this.buf.toString();
    }

    public SignatureVisitor visitClassBound() {
        return this;
    }

    public void visitEnd() {
        this.endArguments();
        this.buf.append(';');
    }

    public SignatureVisitor visitSuperclass() {
        this.endFormals();
        return this;
    }

    public SignatureWriter() {
        super(327680);
    }

    public void visitFormalTypeParameter(String name) {
        if (!this.hasFormals) {
            this.hasFormals = true;
            this.buf.append('<');
        }
        this.buf.append(name);
        this.buf.append(':');
    }

    public SignatureVisitor visitReturnType() {
        this.endFormals();
        if (!this.hasParameters) {
            this.buf.append('(');
        }
        this.buf.append(')');
        return this;
    }

    public SignatureVisitor visitInterfaceBound() {
        this.buf.append(':');
        return this;
    }
}

