/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.tree;

import java.util.ArrayList;
import java.util.List;
import org.spongepowered.asm.lib.AnnotationVisitor;
import pers.XiaoShadiao.NMSLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationNode
extends AnnotationVisitor {
    public String desc;
    public List<Object> values;
    private static final NMSLException \u6211\u4eec\u559c\u6b22\u4f60 = new NMSLException("\u4277\u4dda\u4df1\u4deb\u4dc5\ua647\u26c2\ua64a\u4de9\ua67e\u4dfb\ua67b\ua699\u4a6d\u4de3\u42f7\ua666\u4df2\u3e75\u4dcb\u4dc1\u279f\u2615\u4de6\u4dc4\u26c8\u4dc6\u4ddf\u4ddf\u4de3\u4dee\u260e\u4dee\u4dd5\u2722\ua648\ua674");

    @Override
    public void visit(String name, Object value) {
        if (this.values == null) {
            this.values = new ArrayList<Object>(this.desc != null ? 2 : 1);
        }
        if (this.desc != null) {
            this.values.add(name);
        }
        if (value instanceof byte[]) {
            byte[] v = (byte[])value;
            ArrayList<Byte> l = new ArrayList<Byte>(v.length);
            for (byte b : v) {
                l.add(b);
            }
            this.values.add(l);
        } else if (value instanceof boolean[]) {
            boolean[] v = (boolean[])value;
            ArrayList<Boolean> l = new ArrayList<Boolean>(v.length);
            for (boolean b : v) {
                l.add(b);
            }
            this.values.add(l);
        } else if (value instanceof short[]) {
            short[] v = (short[])value;
            ArrayList<Short> l = new ArrayList<Short>(v.length);
            for (short s : v) {
                l.add(s);
            }
            this.values.add(l);
        } else if (value instanceof char[]) {
            char[] v = (char[])value;
            ArrayList<Character> l = new ArrayList<Character>(v.length);
            for (char c : v) {
                l.add(Character.valueOf(c));
            }
            this.values.add(l);
        } else if (value instanceof int[]) {
            int[] v = (int[])value;
            ArrayList<Integer> l = new ArrayList<Integer>(v.length);
            for (int i : v) {
                l.add(i);
            }
            this.values.add(l);
        } else if (value instanceof long[]) {
            long[] v = (long[])value;
            ArrayList<Long> l = new ArrayList<Long>(v.length);
            for (long lng : v) {
                l.add(lng);
            }
            this.values.add(l);
        } else if (value instanceof float[]) {
            float[] v = (float[])value;
            ArrayList<Float> l = new ArrayList<Float>(v.length);
            for (float f : v) {
                l.add(Float.valueOf(f));
            }
            this.values.add(l);
        } else if (value instanceof double[]) {
            double[] v = (double[])value;
            ArrayList<Double> l = new ArrayList<Double>(v.length);
            for (double d : v) {
                l.add(d);
            }
            this.values.add(l);
        } else {
            this.values.add(value);
        }
    }

    @Override
    public AnnotationVisitor visitAnnotation(String name, String desc) {
        if (this.values == null) {
            this.values = new ArrayList<Object>(this.desc != null ? 2 : 1);
        }
        if (this.desc != null) {
            this.values.add(name);
        }
        AnnotationNode annotation = new AnnotationNode(desc);
        this.values.add(annotation);
        return annotation;
    }

    public AnnotationNode(int api, String desc) {
        super(api);
        this.desc = desc;
    }

    public void accept(AnnotationVisitor av) {
        if (av != null) {
            if (this.values != null) {
                for (int i = 0; i < this.values.size(); i += 2) {
                    String name = (String)this.values.get(i);
                    Object value = this.values.get(i + 1);
                    AnnotationNode.accept(av, name, value);
                }
            }
            av.visitEnd();
        }
    }

    public void check(int api) {
    }

    static void accept(AnnotationVisitor av, String name, Object value) {
        if (av != null) {
            if (value instanceof String[]) {
                String[] typeconst = (String[])value;
                av.visitEnum(name, typeconst[0], typeconst[1]);
            } else if (value instanceof AnnotationNode) {
                AnnotationNode an = (AnnotationNode)value;
                an.accept(av.visitAnnotation(name, an.desc));
            } else if (value instanceof List) {
                AnnotationVisitor v = av.visitArray(name);
                if (v != null) {
                    List array = (List)value;
                    for (int j = 0; j < array.size(); ++j) {
                        AnnotationNode.accept(v, null, array.get(j));
                    }
                    v.visitEnd();
                }
            } else {
                av.visit(name, value);
            }
        }
    }

    @Override
    public void visitEnd() {
    }

    @Override
    public void visitEnum(String name, String desc, String value) {
        if (this.values == null) {
            this.values = new ArrayList<Object>(this.desc != null ? 2 : 1);
        }
        if (this.desc != null) {
            this.values.add(name);
        }
        this.values.add(new String[]{desc, value});
    }

    @Override
    public AnnotationVisitor visitArray(String name) {
        if (this.values == null) {
            this.values = new ArrayList<Object>(this.desc != null ? 2 : 1);
        }
        if (this.desc != null) {
            this.values.add(name);
        }
        ArrayList<Object> array = new ArrayList<Object>();
        this.values.add(array);
        return new AnnotationNode(array);
    }

    AnnotationNode(List<Object> values) {
        super(327680);
        this.values = values;
    }

    public AnnotationNode(String desc) {
        this(327680, desc);
        if (this.getClass() != AnnotationNode.class) {
            throw new IllegalStateException();
        }
    }
}

