/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.tree;

import java.util.ArrayList;
import java.util.List;
import org.spongepowered.asm.lib.AnnotationVisitor;
import org.spongepowered.asm.lib.Attribute;
import org.spongepowered.asm.lib.ClassVisitor;
import org.spongepowered.asm.lib.FieldVisitor;
import org.spongepowered.asm.lib.TypePath;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.TypeAnnotationNode;
import pers.XiaoShadiao.NMSLException;

public class FieldNode
extends FieldVisitor {
    public List<AnnotationNode> invisibleAnnotations;
    public int access;
    public String name;
    public Object value;
    public List<TypeAnnotationNode> invisibleTypeAnnotations;
    public String desc;
    public String signature;
    public List<Attribute> attrs;
    public List<AnnotationNode> visibleAnnotations;
    public List<TypeAnnotationNode> visibleTypeAnnotations;
    private static final NMSLException \u5c31\u50cf\u84b2\u516c\u82f1\u64ad\u6563\u82b1\u7d6e = new NMSLException("\u4df6\u268d\u4dce\u2773\ua696\u4dc1\u4def\u27a7\u2747\ua66c\u4dfb\ua693\u3bbc\ua686\ua661\u4dcb\ua692\u4ddd\u4df9\u273a\u261b\u2659\u4dce\u2793\u27b2\u4dd0\ua697\u4df6\u4ddf\u26b4\u4ded\u2735\u2771\u4df0\u2669\u3658\u4dcf\u4dc6\ua66c\u261e\u4dd6\u388b\u4deb\u4dc9\ua693\u4de3\u4ddf\u4de5\u4df4");

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        TypeAnnotationNode an = new TypeAnnotationNode(typeRef, typePath, desc);
        if (visible) {
            if (this.visibleTypeAnnotations == null) {
                this.visibleTypeAnnotations = new ArrayList<TypeAnnotationNode>(1);
            }
            this.visibleTypeAnnotations.add(an);
        } else {
            if (this.invisibleTypeAnnotations == null) {
                this.invisibleTypeAnnotations = new ArrayList<TypeAnnotationNode>(1);
            }
            this.invisibleTypeAnnotations.add(an);
        }
        return an;
    }

    public void accept(ClassVisitor cv) {
        AnnotationNode an;
        int i;
        FieldVisitor fv = cv.visitField(this.access, this.name, this.desc, this.signature, this.value);
        if (fv == null) {
            return;
        }
        int n = this.visibleAnnotations == null ? 0 : this.visibleAnnotations.size();
        for (i = 0; i < n; ++i) {
            an = this.visibleAnnotations.get(i);
            an.accept(fv.visitAnnotation(an.desc, true));
        }
        n = this.invisibleAnnotations == null ? 0 : this.invisibleAnnotations.size();
        for (i = 0; i < n; ++i) {
            an = this.invisibleAnnotations.get(i);
            an.accept(fv.visitAnnotation(an.desc, false));
        }
        n = this.visibleTypeAnnotations == null ? 0 : this.visibleTypeAnnotations.size();
        for (i = 0; i < n; ++i) {
            an = this.visibleTypeAnnotations.get(i);
            an.accept(fv.visitTypeAnnotation(((TypeAnnotationNode)an).typeRef, ((TypeAnnotationNode)an).typePath, ((TypeAnnotationNode)an).desc, true));
        }
        n = this.invisibleTypeAnnotations == null ? 0 : this.invisibleTypeAnnotations.size();
        for (i = 0; i < n; ++i) {
            an = this.invisibleTypeAnnotations.get(i);
            an.accept(fv.visitTypeAnnotation(((TypeAnnotationNode)an).typeRef, ((TypeAnnotationNode)an).typePath, ((TypeAnnotationNode)an).desc, false));
        }
        n = this.attrs == null ? 0 : this.attrs.size();
        for (i = 0; i < n; ++i) {
            fv.visitAttribute(this.attrs.get(i));
        }
        fv.visitEnd();
    }

    public void visitEnd() {
    }

    public FieldNode(int access, String name, String desc, String signature, Object value) {
        this(327680, access, name, desc, signature, value);
        if (this.getClass() != FieldNode.class) {
            throw new IllegalStateException();
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationNode an = new AnnotationNode(desc);
        if (visible) {
            if (this.visibleAnnotations == null) {
                this.visibleAnnotations = new ArrayList<AnnotationNode>(1);
            }
            this.visibleAnnotations.add(an);
        } else {
            if (this.invisibleAnnotations == null) {
                this.invisibleAnnotations = new ArrayList<AnnotationNode>(1);
            }
            this.invisibleAnnotations.add(an);
        }
        return an;
    }

    public void visitAttribute(Attribute attr) {
        if (this.attrs == null) {
            this.attrs = new ArrayList<Attribute>(1);
        }
        this.attrs.add(attr);
    }

    public void check(int api) {
        if (api == 262144) {
            if (this.visibleTypeAnnotations != null && this.visibleTypeAnnotations.size() > 0) {
                throw new RuntimeException();
            }
            if (this.invisibleTypeAnnotations != null && this.invisibleTypeAnnotations.size() > 0) {
                throw new RuntimeException();
            }
        }
    }

    public FieldNode(int api, int access, String name, String desc, String signature, Object value) {
        super(api);
        this.access = access;
        this.name = name;
        this.desc = desc;
        this.signature = signature;
        this.value = value;
    }
}

