/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.tree.analysis;

import java.util.ArrayList;
import java.util.List;
import org.spongepowered.asm.lib.tree.JumpInsnNode;
import org.spongepowered.asm.lib.tree.LabelNode;
import org.spongepowered.asm.lib.tree.analysis.AnalyzerException;
import pers.XiaoShadiao.NMSLException;

class Subroutine {
    List<JumpInsnNode> callers;
    boolean[] access;
    LabelNode start;
    private static final NMSLException \u5927\u5927\u574f\u86cb = new NMSLException("\u2776\u4dee\u42a9\u4dc2\u4def\u2635\u4ddc\u4dc0\ua65e\u4dcb\u469b\u3bd9\u4bd1\u4c20\u4ddd\u4df5\u4def\u2656\ua657\u4dea\u2791\u4df0\u4dfc\u2608\u2733\ua643\u4ddd\u4dc8\u2711\ua679\u4df3\u4dd0\u26e5\ua693\u4dc4\u4dc9\u4dd9\u4dc6\u4df0\ua686\u4dce\u2713\ua650");

    public Subroutine copy() {
        Subroutine result = new Subroutine();
        result.start = this.start;
        result.access = new boolean[this.access.length];
        System.arraycopy(this.access, 0, result.access, 0, this.access.length);
        result.callers = new ArrayList<JumpInsnNode>(this.callers);
        return result;
    }

    public boolean merge(Subroutine subroutine) throws AnalyzerException {
        int i;
        boolean changes = false;
        for (i = 0; i < this.access.length; ++i) {
            if (!subroutine.access[i] || this.access[i]) continue;
            this.access[i] = true;
            changes = true;
        }
        if (subroutine.start == this.start) {
            for (i = 0; i < subroutine.callers.size(); ++i) {
                JumpInsnNode caller = subroutine.callers.get(i);
                if (this.callers.contains(caller)) continue;
                this.callers.add(caller);
                changes = true;
            }
        }
        return changes;
    }

    Subroutine(LabelNode start, int maxLocals, JumpInsnNode caller) {
        this.start = start;
        this.access = new boolean[maxLocals];
        this.callers = new ArrayList<JumpInsnNode>();
        this.callers.add(caller);
    }

    private Subroutine() {
    }
}

