/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.util;

import org.spongepowered.asm.lib.signature.SignatureVisitor;
import org.spongepowered.asm.lib.util.CheckMethodAdapter;
import pers.XiaoShadiao.NMSLException;

public class CheckSignatureAdapter
extends SignatureVisitor {
    public static final int CLASS_SIGNATURE = 0;
    private final int type;
    private final SignatureVisitor sv;
    private static final int RETURN = 32;
    public static final int METHOD_SIGNATURE = 1;
    private static final int PARAM = 16;
    private static final int FORMAL = 2;
    private static final int BOUND = 4;
    private static final int SIMPLE_TYPE = 64;
    private static final int SUPER = 8;
    private int state;
    public static final int TYPE_SIGNATURE = 2;
    private boolean canBeVoid;
    private static final int END = 256;
    private static final int EMPTY = 1;
    private static final int CLASS_TYPE = 128;
    private static final NMSLException \u5982\u679c\u660e\u5929\u89c1\u4e0d\u5230 = new NMSLException("\u4de2\u4dd2\u47b1\u4dea\u2729\u4df4\u4dce\u4dfa\u26f9\u347a\u274d\u4dcd\u26f7\u4dd5\ua651\u2716\u4dcd\u4dfa\u4dce\u4ded\u4dea\u277c\u4df5\u4dd2\ua666\u4de3\u4ddc\u3f28\u2718\u2774\u4dfa\u4dee\u4dc8\u4deb\u4dfc");

    public void visitInnerClassType(String name) {
        if (this.state != 128) {
            throw new IllegalStateException();
        }
        CheckMethodAdapter.checkIdentifier(name, "inner class name");
        if (this.sv != null) {
            this.sv.visitInnerClassType(name);
        }
    }

    public void visitClassType(String name) {
        if (this.type != 2 || this.state != 1) {
            throw new IllegalStateException();
        }
        CheckMethodAdapter.checkInternalName(name, "class name");
        this.state = 128;
        if (this.sv != null) {
            this.sv.visitClassType(name);
        }
    }

    public SignatureVisitor visitExceptionType() {
        if (this.state != 32) {
            throw new IllegalStateException();
        }
        SignatureVisitor v = this.sv == null ? null : this.sv.visitExceptionType();
        return new CheckSignatureAdapter(2, v);
    }

    public SignatureVisitor visitSuperclass() {
        if (this.type != 0 || (this.state & 7) == 0) {
            throw new IllegalArgumentException();
        }
        this.state = 8;
        SignatureVisitor v = this.sv == null ? null : this.sv.visitSuperclass();
        return new CheckSignatureAdapter(2, v);
    }

    public SignatureVisitor visitInterfaceBound() {
        if (this.state != 2 && this.state != 4) {
            throw new IllegalArgumentException();
        }
        SignatureVisitor v = this.sv == null ? null : this.sv.visitInterfaceBound();
        return new CheckSignatureAdapter(2, v);
    }

    public SignatureVisitor visitParameterType() {
        if (this.type != 1 || (this.state & 0x17) == 0) {
            throw new IllegalArgumentException();
        }
        this.state = 16;
        SignatureVisitor v = this.sv == null ? null : this.sv.visitParameterType();
        return new CheckSignatureAdapter(2, v);
    }

    public SignatureVisitor visitClassBound() {
        if (this.state != 2) {
            throw new IllegalStateException();
        }
        this.state = 4;
        SignatureVisitor v = this.sv == null ? null : this.sv.visitClassBound();
        return new CheckSignatureAdapter(2, v);
    }

    public void visitEnd() {
        if (this.state != 128) {
            throw new IllegalStateException();
        }
        this.state = 256;
        if (this.sv != null) {
            this.sv.visitEnd();
        }
    }

    public SignatureVisitor visitTypeArgument(char wildcard) {
        if (this.state != 128) {
            throw new IllegalStateException();
        }
        if ("+-=".indexOf(wildcard) == -1) {
            throw new IllegalArgumentException();
        }
        SignatureVisitor v = this.sv == null ? null : this.sv.visitTypeArgument(wildcard);
        return new CheckSignatureAdapter(2, v);
    }

    public SignatureVisitor visitArrayType() {
        if (this.type != 2 || this.state != 1) {
            throw new IllegalStateException();
        }
        this.state = 64;
        SignatureVisitor v = this.sv == null ? null : this.sv.visitArrayType();
        return new CheckSignatureAdapter(2, v);
    }

    protected CheckSignatureAdapter(int api, int type, SignatureVisitor sv) {
        super(api);
        this.type = type;
        this.state = 1;
        this.sv = sv;
    }

    public void visitBaseType(char descriptor) {
        if (this.type != 2 || this.state != 1) {
            throw new IllegalStateException();
        }
        if (descriptor == 'V' ? !this.canBeVoid : "ZCBSIFJD".indexOf(descriptor) == -1) {
            throw new IllegalArgumentException();
        }
        this.state = 64;
        if (this.sv != null) {
            this.sv.visitBaseType(descriptor);
        }
    }

    public void visitTypeArgument() {
        if (this.state != 128) {
            throw new IllegalStateException();
        }
        if (this.sv != null) {
            this.sv.visitTypeArgument();
        }
    }

    public void visitTypeVariable(String name) {
        if (this.type != 2 || this.state != 1) {
            throw new IllegalStateException();
        }
        CheckMethodAdapter.checkIdentifier(name, "type variable");
        this.state = 64;
        if (this.sv != null) {
            this.sv.visitTypeVariable(name);
        }
    }

    public SignatureVisitor visitInterface() {
        if (this.state != 8) {
            throw new IllegalStateException();
        }
        SignatureVisitor v = this.sv == null ? null : this.sv.visitInterface();
        return new CheckSignatureAdapter(2, v);
    }

    public void visitFormalTypeParameter(String name) {
        if (this.type == 2 || this.state != 1 && this.state != 2 && this.state != 4) {
            throw new IllegalStateException();
        }
        CheckMethodAdapter.checkIdentifier(name, "formal type parameter");
        this.state = 2;
        if (this.sv != null) {
            this.sv.visitFormalTypeParameter(name);
        }
    }

    public CheckSignatureAdapter(int type, SignatureVisitor sv) {
        this(327680, type, sv);
    }

    public SignatureVisitor visitReturnType() {
        if (this.type != 1 || (this.state & 0x17) == 0) {
            throw new IllegalArgumentException();
        }
        this.state = 32;
        SignatureVisitor v = this.sv == null ? null : this.sv.visitReturnType();
        CheckSignatureAdapter cv = new CheckSignatureAdapter(2, v);
        cv.canBeVoid = true;
        return cv;
    }
}

