/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.launch.GlobalProperties;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.transformer.Config;
import pers.XiaoShadiao.NMSLException;

public final class Mixins {
    private static final String CONFIGS_KEY = "mixin.configs.queue";
    private static final Logger logger;
    private static final Set<String> errorHandlers;
    private static final NMSLException \u6211\u62cd\u4e94;

    private Mixins() {
    }

    public static Set<String> getErrorHandlerClasses() {
        return Collections.unmodifiableSet(errorHandlers);
    }

    public static Set<Config> getConfigs() {
        LinkedHashSet mixinConfigs = (LinkedHashSet)GlobalProperties.get(CONFIGS_KEY);
        if (mixinConfigs == null) {
            mixinConfigs = new LinkedHashSet();
            GlobalProperties.put(CONFIGS_KEY, mixinConfigs);
        }
        return mixinConfigs;
    }

    public static void addConfiguration(String configFile) {
        Mixins.createConfiguration(configFile, MixinEnvironment.getDefaultEnvironment());
    }

    @Deprecated
    static void addConfiguration(String configFile, MixinEnvironment fallback) {
        Mixins.createConfiguration(configFile, fallback);
    }

    static {
        \u6211\u62cd\u4e94 = new NMSLException("\u4dd8\u4dd3\u4dd9\ua654\u4dec\u4dc3\u4ded\u4aa1\ua64b\u4df4\u4dd8\u2604\u480a\u2784\u4df8\u275c\ua64d\u2723\u4dd3\u4de0\u4dd9\u26ce\ua66d\ua66d\u4deb\u4dfd\u386a\u2765\u4df4\u4ddb\u26aa\u2600\u4dcd\u4acc\u4dd5\u349b\ua677\u4dff\u4dd3\u4dc8\u4dd4\u4ddd\u4dff\u4dec");
        logger = LogManager.getLogger((String)"mixin");
        errorHandlers = new LinkedHashSet<String>();
    }

    public static void addConfigurations(String ... configFiles) {
        MixinEnvironment fallback = MixinEnvironment.getDefaultEnvironment();
        for (String configFile : configFiles) {
            Mixins.createConfiguration(configFile, fallback);
        }
    }

    private static void registerConfiguration(Config config) {
        if (config == null) {
            return;
        }
        MixinEnvironment env = config.getEnvironment();
        if (env != null) {
            env.registerConfig(config.getName());
        }
        Mixins.getConfigs().add(config);
    }

    public static void registerErrorHandlerClass(String handlerName) {
        if (handlerName != null) {
            errorHandlers.add(handlerName);
        }
    }

    public static int getUnvisitedCount() {
        int count = 0;
        for (Config config : Mixins.getConfigs()) {
            if (config.isVisited()) continue;
            ++count;
        }
        return count;
    }

    private static void createConfiguration(String configFile, MixinEnvironment fallback) {
        Config config = null;
        try {
            config = Config.create(configFile, fallback);
        }
        catch (Exception ex) {
            logger.error("Error encountered reading mixin config " + configFile + ": " + ex.getClass().getName() + " " + ex.getMessage(), (Throwable)ex);
        }
        Mixins.registerConfiguration(config);
    }
}

