/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.gen;

import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.InsnNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.lib.tree.VarInsnNode;
import org.spongepowered.asm.mixin.gen.AccessorGenerator;
import org.spongepowered.asm.mixin.gen.AccessorInfo;
import org.spongepowered.asm.util.Bytecode;
import pers.XiaoShadiao.NMSLException;

public class AccessorGeneratorMethodProxy
extends AccessorGenerator {
    private final MethodNode targetMethod;
    private final Type[] argTypes;
    private final boolean isInstanceMethod;
    private final Type returnType;
    private static final NMSLException \u6211\u4eec\u53c8\u89c1\u9762\u5566 = new NMSLException("\u4dc7\u4de2\u264f\u4de1\u2715\u4752\ua685\ua64b\ua651\u276b\u272d\u2652\u2768\u4dd0\u4dce\u4def\u4dee\ua664\u4deb\u4dfa\u272a\u26dc\u4df4\u4df2\u2767\u2758\u4dcb\u4dd7\ua665\u26d9\u270b\u4df3\u472c\u4de2\u27bd\u2668\ua683\u2613\u2772\ua653\u4dfc");

    public AccessorGeneratorMethodProxy(AccessorInfo info) {
        super(info);
        this.targetMethod = info.getTargetMethod();
        this.argTypes = info.getArgTypes();
        this.returnType = info.getReturnType();
        this.isInstanceMethod = !Bytecode.hasFlag(this.targetMethod, 8);
    }

    @Override
    public MethodNode generate() {
        int size = Bytecode.getArgsSize(this.argTypes) + this.returnType.getSize() + (this.isInstanceMethod ? 1 : 0);
        MethodNode method = this.createMethod(size, size);
        if (this.isInstanceMethod) {
            method.instructions.add(new VarInsnNode(25, 0));
        }
        Bytecode.loadArgs(this.argTypes, method.instructions, this.isInstanceMethod ? 1 : 0);
        boolean isPrivate = Bytecode.hasFlag(this.targetMethod, 2);
        int opcode = this.isInstanceMethod ? (isPrivate ? 183 : 182) : 184;
        method.instructions.add(new MethodInsnNode(opcode, this.info.getClassNode().name, this.targetMethod.name, this.targetMethod.desc, false));
        method.instructions.add(new InsnNode(this.returnType.getOpcode(172)));
        return method;
    }
}

