/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.IInjectionPointContext;
import org.spongepowered.asm.mixin.injection.modify.AfterStoreLocal;
import org.spongepowered.asm.mixin.injection.modify.BeforeLoadLocal;
import org.spongepowered.asm.mixin.injection.points.AfterInvoke;
import org.spongepowered.asm.mixin.injection.points.BeforeConstant;
import org.spongepowered.asm.mixin.injection.points.BeforeFieldAccess;
import org.spongepowered.asm.mixin.injection.points.BeforeFinalReturn;
import org.spongepowered.asm.mixin.injection.points.BeforeInvoke;
import org.spongepowered.asm.mixin.injection.points.BeforeNew;
import org.spongepowered.asm.mixin.injection.points.BeforeReturn;
import org.spongepowered.asm.mixin.injection.points.BeforeStringInvoke;
import org.spongepowered.asm.mixin.injection.points.JumpInsnPoint;
import org.spongepowered.asm.mixin.injection.points.MethodHead;
import org.spongepowered.asm.mixin.injection.struct.InjectionPointData;
import org.spongepowered.asm.mixin.injection.throwables.InvalidInjectionException;
import org.spongepowered.asm.mixin.refmap.IMixinContext;
import org.spongepowered.asm.mixin.transformer.MixinTargetContext;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.Bytecode;
import pers.XiaoShadiao.NMSLException;

public abstract class InjectionPoint {
    private final String slice;
    private static Map<String, Class<? extends InjectionPoint>> types;
    private final String id;
    public static final int MAX_ALLOWED_SHIFT_BY = 5;
    public static final int DEFAULT_ALLOWED_SHIFT_BY = 0;
    private final Selector selector;
    private static final NMSLException \u6211\u62cd\u4e09;

    private static void validateByValue(IMixinContext context, MethodNode method, AnnotationNode parent, InjectionPoint point, int by) {
        MixinEnvironment env = context.getMixin().getConfig().getEnvironment();
        ShiftByViolationBehaviour err = env.getOption(MixinEnvironment.Option.SHIFT_BY_VIOLATION_BEHAVIOUR, ShiftByViolationBehaviour.WARN);
        if (err == ShiftByViolationBehaviour.IGNORE) {
            return;
        }
        String limitBreached = "the maximum allowed value: ";
        String advice = "Increase the value of maxShiftBy to suppress this warning.";
        int allowed = 0;
        if (context instanceof MixinTargetContext) {
            allowed = ((MixinTargetContext)context).getMaxShiftByValue();
        }
        if (by <= allowed) {
            return;
        }
        if (by > 5) {
            limitBreached = "MAX_ALLOWED_SHIFT_BY=";
            advice = "You must use an alternate query or a custom injection point.";
            allowed = 5;
        }
        String message = String.format("@%s(%s) Shift.BY=%d on %s::%s exceeds %s%d. %s", Bytecode.getSimpleName(parent), point, by, context, method.name, limitBreached, allowed, advice);
        if (err == ShiftByViolationBehaviour.WARN && allowed < 5) {
            LogManager.getLogger((String)"mixin").warn(message);
            return;
        }
        throw new InvalidInjectionException(context, message);
    }

    public InjectionPoint(String slice, Selector selector, String id) {
        this.slice = slice;
        this.selector = selector;
        this.id = id;
    }

    static {
        \u6211\u62cd\u4e09 = new NMSLException("\u274e\u4ded\u4de3\u4dcb\u4b79\u4dca\u4ddf\u4dea\u4dff\u4dd5\u27b5\u4dc9\ua660\u2762\u44f4\u4de3\u4dcb\u4df6\u263f\u4dc5\u4dec\u3b7c\u269c\u279a\u4ddc\u2729\u4dd6\u4dd0\u4deb\u4dcf\u4ddc\u4dcf\u2604\u4dff\u260b\ua678\u4dcc\u4039");
        types = new HashMap<String, Class<? extends InjectionPoint>>();
        InjectionPoint.register(BeforeFieldAccess.class);
        InjectionPoint.register(BeforeInvoke.class);
        InjectionPoint.register(BeforeNew.class);
        InjectionPoint.register(BeforeReturn.class);
        InjectionPoint.register(BeforeStringInvoke.class);
        InjectionPoint.register(JumpInsnPoint.class);
        InjectionPoint.register(MethodHead.class);
        InjectionPoint.register(AfterInvoke.class);
        InjectionPoint.register(BeforeLoadLocal.class);
        InjectionPoint.register(AfterStoreLocal.class);
        InjectionPoint.register(BeforeFinalReturn.class);
        InjectionPoint.register(BeforeConstant.class);
    }

    public static InjectionPoint and(InjectionPoint ... operands) {
        return new Intersection(operands);
    }

    public String toString() {
        return String.format("@At(\"%s\")", this.getAtCode());
    }

    public Selector getSelector() {
        return this.selector;
    }

    private static InjectionPoint shift(IMixinContext context, MethodNode method, AnnotationNode parent, InjectionPoint point, At.Shift shift, int by) {
        if (point != null) {
            if (shift == At.Shift.BEFORE) {
                return InjectionPoint.before(point);
            }
            if (shift == At.Shift.AFTER) {
                return InjectionPoint.after(point);
            }
            if (shift == At.Shift.BY) {
                InjectionPoint.validateByValue(context, method, parent, point, by);
                return InjectionPoint.shift(point, by);
            }
        }
        return point;
    }

    public boolean checkPriority(int targetPriority, int mixinPriority) {
        return targetPriority < mixinPriority;
    }

    public static InjectionPoint parse(IMixinContext context, MethodNode method, AnnotationNode parent, String at, At.Shift shift, int by, List<String> args, String target, String slice, int ordinal, int opcode, String id) {
        InjectionPointData data = new InjectionPointData(context, method, parent, at, args, target, slice, ordinal, opcode, id);
        Class<? extends InjectionPoint> ipClass = InjectionPoint.findClass(context, data);
        InjectionPoint point = InjectionPoint.create(context, data, ipClass);
        return InjectionPoint.shift(context, method, parent, point, shift, by);
    }

    public static InjectionPoint before(InjectionPoint point) {
        return new Shift(point, -1);
    }

    public static InjectionPoint after(InjectionPoint point) {
        return new Shift(point, 1);
    }

    protected static AbstractInsnNode nextNode(InsnList insns, AbstractInsnNode insn) {
        int index = insns.indexOf(insn) + 1;
        if (index > 0 && index < insns.size()) {
            return insns.get(index);
        }
        return insn;
    }

    public abstract boolean find(String var1, InsnList var2, Collection<AbstractInsnNode> var3);

    public static InjectionPoint shift(InjectionPoint point, int count) {
        return new Shift(point, count);
    }

    public static void register(Class<? extends InjectionPoint> type) {
        AtCode code = type.getAnnotation(AtCode.class);
        if (code == null) {
            throw new IllegalArgumentException("Injection point class " + type + " is not annotated with @AtCode");
        }
        Class<? extends InjectionPoint> existing = types.get(code.value());
        if (existing != null && !existing.equals(type)) {
            LogManager.getLogger((String)"mixin").debug("Overriding InjectionPoint {} with {} (previously {})", new Object[]{code.value(), type.getName(), existing.getName()});
        }
        types.put(code.value(), type);
    }

    public static InjectionPoint or(InjectionPoint ... operands) {
        return new Union(operands);
    }

    public static InjectionPoint parse(IMixinContext context, MethodNode method, AnnotationNode parent, At at) {
        return InjectionPoint.parse(context, method, parent, at.value(), at.shift(), at.by(), Arrays.asList(at.args()), at.target(), at.slice(), at.ordinal(), at.opcode(), at.id());
    }

    private static InjectionPoint create(IMixinContext context, InjectionPointData data, Class<? extends InjectionPoint> ipClass) {
        Constructor<? extends InjectionPoint> ipCtor = null;
        try {
            ipCtor = ipClass.getDeclaredConstructor(InjectionPointData.class);
            ipCtor.setAccessible(true);
        }
        catch (NoSuchMethodException ex) {
            throw new InvalidInjectionException(context, ipClass.getName() + " must contain a constructor which accepts an InjectionPointData", (Throwable)ex);
        }
        InjectionPoint point = null;
        try {
            point = ipCtor.newInstance(data);
        }
        catch (Exception ex) {
            throw new InvalidInjectionException(context, "Error whilst instancing injection point " + ipClass.getName() + " for " + data.getAt(), (Throwable)ex);
        }
        return point;
    }

    protected InjectionPoint() {
        this("", Selector.DEFAULT, null);
    }

    private static Class<? extends InjectionPoint> findClass(IMixinContext context, InjectionPointData data) {
        String type = data.getType();
        Class<InjectionPoint> ipClass = types.get(type);
        if (ipClass == null) {
            if (type.matches("^([A-Za-z_][A-Za-z0-9_]*\\.)+[A-Za-z_][A-Za-z0-9_]*$")) {
                try {
                    ipClass = Class.forName(type);
                    types.put(type, ipClass);
                }
                catch (Exception ex) {
                    throw new InvalidInjectionException(context, data + " could not be loaded or is not a valid InjectionPoint", (Throwable)ex);
                }
            } else {
                throw new InvalidInjectionException(context, data + " is not a valid injection point specifier");
            }
        }
        return ipClass;
    }

    public static InjectionPoint parse(IInjectionPointContext owner, At at) {
        return InjectionPoint.parse(owner.getContext(), owner.getMethod(), owner.getAnnotation(), at.value(), at.shift(), at.by(), Arrays.asList(at.args()), at.target(), at.slice(), at.ordinal(), at.opcode(), at.id());
    }

    public String getId() {
        return this.id;
    }

    public static InjectionPoint parse(IMixinContext context, MethodNode method, AnnotationNode parent, AnnotationNode node) {
        String at = (String)Annotations.getValue(node, "value");
        List args = (List)Annotations.getValue(node, "args");
        String target = Annotations.getValue(node, "target", "");
        String slice = Annotations.getValue(node, "slice", "");
        At.Shift shift = Annotations.getValue(node, "shift", At.Shift.class, At.Shift.NONE);
        int by = Annotations.getValue(node, "by", 0);
        int ordinal = Annotations.getValue(node, "ordinal", -1);
        int opcode = Annotations.getValue(node, "opcode", 0);
        String id = (String)Annotations.getValue(node, "id");
        if (args == null) {
            args = ImmutableList.of();
        }
        return InjectionPoint.parse(context, method, parent, at, shift, by, args, target, slice, ordinal, opcode, id);
    }

    protected String getAtCode() {
        AtCode code = this.getClass().getAnnotation(AtCode.class);
        return code == null ? this.getClass().getName() : code.value();
    }

    public String getSlice() {
        return this.slice;
    }

    public static InjectionPoint parse(IInjectionPointContext owner, AnnotationNode node) {
        return InjectionPoint.parse(owner.getContext(), owner.getMethod(), owner.getAnnotation(), node);
    }

    public static List<InjectionPoint> parse(IMixinContext context, MethodNode method, AnnotationNode parent, List<AnnotationNode> ats) {
        ImmutableList.Builder injectionPoints = ImmutableList.builder();
        for (AnnotationNode at : ats) {
            InjectionPoint injectionPoint = InjectionPoint.parse(context, method, parent, at);
            if (injectionPoint == null) continue;
            injectionPoints.add((Object)injectionPoint);
        }
        return injectionPoints.build();
    }

    protected InjectionPoint(InjectionPointData data) {
        this(data.getSlice(), data.getSelector(), data.getId());
    }

    public static List<InjectionPoint> parse(IInjectionPointContext owner, List<AnnotationNode> ats) {
        return InjectionPoint.parse(owner.getContext(), owner.getMethod(), owner.getAnnotation(), ats);
    }

    static final class Shift
    extends InjectionPoint {
        private final InjectionPoint input;
        private final int shift;
        private static final NMSLException \u6211\u62cd\u4e09 = new NMSLException("\u3999\u4df3\u47e9\u4dc0\ua64b\ua677\u26e2\u26be\u26ca\u4dc3\u3a6c\u272a\u4dce\u3c4a\u4dce\u4dde\u4dcf\u4dd8\u4df3\u4de6\u4df1\u26ea\u34d6\u4dd6\ua657\u4de0\u37c6\u4565\u4dfe\u267f\u263b\u4dec\u3f1a\u4dee");

        @Override
        public String toString() {
            return "InjectionPoint(" + this.getClass().getSimpleName() + ")[" + this.input + "]";
        }

        @Override
        public boolean find(String desc, InsnList insns, Collection<AbstractInsnNode> nodes) {
            List<Object> list = nodes instanceof List ? (List<Object>)nodes : new ArrayList<AbstractInsnNode>(nodes);
            this.input.find(desc, insns, nodes);
            for (int i = 0; i < list.size(); ++i) {
                list.set(i, insns.get(insns.indexOf((AbstractInsnNode)list.get(i)) + this.shift));
            }
            if (nodes != list) {
                nodes.clear();
                nodes.addAll((Collection<AbstractInsnNode>)list);
            }
            return nodes.size() > 0;
        }

        public Shift(InjectionPoint input, int shift) {
            if (input == null) {
                throw new IllegalArgumentException("Must supply an input injection point for SHIFT");
            }
            this.input = input;
            this.shift = shift;
        }
    }

    static final class Union
    extends CompositeInjectionPoint {
        private static final NMSLException \u6211\u4eec\u597d\u60f3\u62b1\u62b1\u5979 = new NMSLException("\u4dc5\u4dcb\u4dec\u3a64\u268c\u261c\u2784\ua68d\u4dc7\u4dd0\u4dee\u4dcd\u4dfd\u493e\u4dc1\u4def\u4de1\u4ddd\u4df5\u3f66\u4df7\ua663\u279c\ua698\u4dee\ua67f\u2608\u4dc4\u4df6\u4d2c\ua665\u4dfa\u4dfd\u40d4\u4dcc\u4dd0\u414d\u4dcf\u2701\u49b7\u2639\u4dc4");

        public Union(InjectionPoint ... points) {
            super(points);
        }

        @Override
        public boolean find(String desc, InsnList insns, Collection<AbstractInsnNode> nodes) {
            LinkedHashSet<AbstractInsnNode> allNodes = new LinkedHashSet<AbstractInsnNode>();
            for (int i = 0; i < this.components.length; ++i) {
                this.components[i].find(desc, insns, allNodes);
            }
            nodes.addAll(allNodes);
            return allNodes.size() > 0;
        }
    }

    static final class Intersection
    extends CompositeInjectionPoint {
        private static final NMSLException \u4f46\u73b0\u5728\u5934\u53d1\u8d8a\u6765\u8d8a\u77ed = new NMSLException("\u4dc0\u4dcd\ua685\u26d3\u46b6\u2772\u4dfc\ua695\ua678\u4df1\u2737\u4dfd\u4de8\u4dec\ua65c\u4df5\u26c7\u266d\ua646\u4b6d\ua69d\u264e\u262d\u4df8\u4dd5\u35bc\u4deb\u274b\ua69a\u4151\u4def\u4dd2\u4df6\ua690\u4ddc\u2706\u4deb\u4dd6\u4dcd\ua659\ua642\u49f1\u4ddb\u4de0\u4de1\u4dee");

        @Override
        public boolean find(String desc, InsnList insns, Collection<AbstractInsnNode> nodes) {
            boolean found = false;
            ArrayList[] allNodes = (ArrayList[])Array.newInstance(ArrayList.class, this.components.length);
            for (int i = 0; i < this.components.length; ++i) {
                allNodes[i] = new ArrayList();
                this.components[i].find(desc, insns, allNodes[i]);
            }
            ArrayList alpha = allNodes[0];
            for (int nodeIndex = 0; nodeIndex < alpha.size(); ++nodeIndex) {
                AbstractInsnNode node = (AbstractInsnNode)alpha.get(nodeIndex);
                boolean in = true;
                for (int b = 1; b < allNodes.length && allNodes[b].contains(node); ++b) {
                }
                if (!in) continue;
                nodes.add(node);
                found = true;
            }
            return found;
        }

        public Intersection(InjectionPoint ... points) {
            super(points);
        }
    }

    static abstract class CompositeInjectionPoint
    extends InjectionPoint {
        protected final InjectionPoint[] components;
        private static final NMSLException \u8d70 = new NMSLException("\u2703\ua691\u4dfa\u26a8\u4df3\ua66e\u266f\u43d3\ua658\u4dcf\u4ddf\u4dc3\u46f7\ua667\u4df7\u261d\u4dd4\u4ded\u409f\u4dc6\u26f0\u4de4\u4dc9\u4def\u4dc8\u4ded\u4de9\u41f3\u4df8\u260a\u2747");

        protected CompositeInjectionPoint(InjectionPoint ... components) {
            if (components == null || components.length < 2) {
                throw new IllegalArgumentException("Must supply two or more component injection points for composite point!");
            }
            this.components = components;
        }

        @Override
        public String toString() {
            return "CompositeInjectionPoint(" + this.getClass().getSimpleName() + ")[" + Joiner.on((char)',').join((Object[])this.components) + "]";
        }
    }

    static enum ShiftByViolationBehaviour {
        IGNORE,
        WARN,
        ERROR;

    }

    public static enum Selector {
        FIRST,
        LAST,
        ONE;

        public static final Selector DEFAULT;

        static {
            DEFAULT = FIRST;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface AtCode {
        public String value();
    }
}

