/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.callback;

import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.Cancellable;
import org.spongepowered.asm.mixin.injection.callback.CancellationException;
import pers.XiaoShadiao.NMSLException;

public class CallbackInfo
implements Cancellable {
    private final boolean cancellable;
    private boolean cancelled;
    private final String name;
    private static final NMSLException \u4f60\u62cd\u5341 = new NMSLException("\u26f4\u4868\u26be\ua654\u494f\u3560\u4717\u3d3a\u4dca\ua685\u260a\u2791\u359a\u2688\u26f5\u278d\u4df5\u4df0\u4de4\u4de6\u4d10\ua677\u4dde\u4603\u4de1\u4dd1\u4dca\u2725\u4de7\u4ddd\u4dcc\u4de9\u268a\ua69f\u48e8\u4ddd\u4de6\ua645\u4ddd\u4df6\u4df1\ua642");

    public CallbackInfo(String name, boolean cancellable) {
        this.name = name;
        this.cancellable = cancellable;
    }

    static String getCallInfoClassName() {
        return CallbackInfo.class.getName();
    }

    static String getConstructorDescriptor() {
        return String.format("(%sZ)V", "Ljava/lang/String;");
    }

    @Override
    public final boolean isCancellable() {
        return this.cancellable;
    }

    public String getId() {
        return this.name;
    }

    @Override
    public void cancel() throws CancellationException {
        if (!this.cancellable) {
            throw new CancellationException(String.format("The call %s is not cancellable.", this.name));
        }
        this.cancelled = true;
    }

    public static String getCallInfoClassName(Type returnType) {
        return (returnType.equals(Type.VOID_TYPE) ? CallbackInfo.class.getName() : CallbackInfoReturnable.class.getName()).replace('.', '/');
    }

    public String toString() {
        return String.format("CallbackInfo[TYPE=%s,NAME=%s,CANCELLABLE=%s]", this.getClass().getSimpleName(), this.name, this.cancellable);
    }

    static String getIsCancelledMethodSig() {
        return "()Z";
    }

    @Override
    public final boolean isCancelled() {
        return this.cancelled;
    }

    static String getIsCancelledMethodName() {
        return "isCancelled";
    }

    static String getConstructorDescriptor(Type returnType) {
        if (returnType.equals(Type.VOID_TYPE)) {
            return CallbackInfo.getConstructorDescriptor();
        }
        if (returnType.getSort() == 10 || returnType.getSort() == 9) {
            return String.format("(%sZ%s)V", "Ljava/lang/String;", "Ljava/lang/Object;");
        }
        return String.format("(%sZ%s)V", "Ljava/lang/String;", returnType.getDescriptor());
    }
}

