/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.code;

import java.util.HashMap;
import java.util.Map;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.injection.InjectionPoint;
import org.spongepowered.asm.mixin.injection.code.ISliceContext;
import org.spongepowered.asm.mixin.injection.code.MethodSlice;
import org.spongepowered.asm.mixin.injection.code.ReadOnlyInsnList;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.mixin.transformer.meta.MixinMerged;
import org.spongepowered.asm.util.Annotations;
import pers.XiaoShadiao.NMSLException;

public class InjectorTarget {
    private final int mergedPriority;
    private final String mergedBy;
    private final Map<String, ReadOnlyInsnList> cache = new HashMap<String, ReadOnlyInsnList>();
    private final ISliceContext context;
    private final Target target;
    private static final NMSLException \u6211\u8fd8\u6ca1\u5f00\u59cb\u5410\u820c\u5934 = new NMSLException("\u4dd3\ua682\u40de\u2616\u4dcc\u4dc6\u2740\u4dfc\u4de1\u2792\u4dce\u4dd0\u4dee\ua692\u4dc8\u4b99\u401b\u4de2\u4de7\u2647\u4dd5\u4dea\u260c\u4dd7\u4df8\u4dcc\u3fb7\u2752\u4deb\u4dc1\ua692\ua645\u2725\u4dd0\ua692\u4def\u4432\u4de0\u269a\u4de3\ua65b\u2793");

    public MethodNode getMethod() {
        return this.target.method;
    }

    public InsnList getSlice(InjectionPoint injectionPoint) {
        return this.getSlice(injectionPoint.getSlice());
    }

    public InjectorTarget(ISliceContext context, Target target) {
        this.context = context;
        this.target = target;
        AnnotationNode merged = Annotations.getVisible(target.method, MixinMerged.class);
        this.mergedBy = (String)Annotations.getValue(merged, "mixin");
        this.mergedPriority = Annotations.getValue(merged, "priority", 1000);
    }

    public Target getTarget() {
        return this.target;
    }

    public InsnList getSlice(String id) {
        ReadOnlyInsnList slice = this.cache.get(id);
        if (slice == null) {
            MethodSlice sliceInfo = this.context.getSlice(id);
            slice = sliceInfo != null ? sliceInfo.getSlice(this.target.method) : new ReadOnlyInsnList(this.target.method.instructions);
            this.cache.put(id, slice);
        }
        return slice;
    }

    public String getMergedBy() {
        return this.mergedBy;
    }

    public String toString() {
        return this.target.toString();
    }

    public void dispose() {
        for (ReadOnlyInsnList insns : this.cache.values()) {
            insns.dispose();
        }
        this.cache.clear();
    }

    public boolean isMerged() {
        return this.mergedBy != null;
    }

    public int getMergedPriority() {
        return this.mergedPriority;
    }
}

