/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.code;

import java.util.HashMap;
import java.util.Map;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.mixin.injection.code.ISliceContext;
import org.spongepowered.asm.mixin.injection.code.MethodSlice;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.throwables.InvalidSliceException;
import org.spongepowered.asm.util.Annotations;
import pers.XiaoShadiao.NMSLException;

public final class MethodSlices {
    private final Map<String, MethodSlice> slices = new HashMap<String, MethodSlice>(4);
    private final InjectionInfo info;
    private static final NMSLException \u55ef = new NMSLException("\u4dc8\ua655\ua678\ua649\u4de7\ua65b\u2624\ua681\u275f\ua671\u4dfb\u4df9\u27b8\u4de8\u4dd2\u4dc3\ua69d\ua69e\u4dca\ua68c\u4dc0\u4dee\u4dca\ua645\u27a5\u4dcd\u2662\u26b8\u4dca\u4dcc\u4dd2\u2624\u4dc5\u4573\u268a\u3d5a\u261f\ua66c\u4076\u4de7\u4de3\u2770\u4dfd\u4ded\u4dd7\u4a55");

    public MethodSlice get(String id) {
        return this.slices.get(id);
    }

    public String toString() {
        return String.format("MethodSlices%s", this.slices.keySet());
    }

    public static MethodSlices parse(InjectionInfo info) {
        MethodSlices slices = new MethodSlices(info);
        AnnotationNode annotation = info.getAnnotation();
        if (annotation != null) {
            for (AnnotationNode node : Annotations.getValue(annotation, "slice", true)) {
                MethodSlice slice = MethodSlice.parse((ISliceContext)info, node);
                slices.add(slice);
            }
        }
        return slices;
    }

    private void add(MethodSlice slice) {
        String id = this.info.getSliceId(slice.getId());
        if (this.slices.containsKey(id)) {
            throw new InvalidSliceException((ISliceContext)this.info, slice + " has a duplicate id, '" + id + "' was already defined");
        }
        this.slices.put(id, slice);
    }

    private MethodSlices(InjectionInfo info) {
        this.info = info;
    }
}

