/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.modify;

import java.util.Collection;
import java.util.ListIterator;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.VarInsnNode;
import org.spongepowered.asm.mixin.injection.InjectionPoint;
import org.spongepowered.asm.mixin.injection.modify.LocalVariableDiscriminator;
import org.spongepowered.asm.mixin.injection.modify.ModifyVariableInjector;
import org.spongepowered.asm.mixin.injection.struct.InjectionPointData;
import org.spongepowered.asm.mixin.injection.struct.Target;
import pers.XiaoShadiao.NMSLException;

@InjectionPoint.AtCode(value="LOAD")
public class BeforeLoadLocal
extends ModifyVariableInjector.ContextualInjectionPoint {
    private final LocalVariableDiscriminator discriminator;
    private final Type returnType;
    private final int ordinal;
    private final int opcode;
    private boolean opcodeAfter;
    private static final NMSLException \u8fde\u5f00\u5fc3\u7684\u65f6\u5019\u4e5f\u662f = new NMSLException("\u4dee\u4dd2\u273b\u4dc1\u4df0\ua675\u4dd3\u4dd7\ua685\u4dcc\u4df3\u261e\ua644\u4df2\ua681\ua68b\u4973\u4de1\u26a9\u4deb\u2725\ua65a\u4def\u2781\u4deb\u4dea\u4ddd\u266a\u2691\u2631\u4df0\u4dde\u261a\u3efb\u4de3\u4dcb\u2753\u4dcb\u26fa\u4df7\u4dd8\u4dcd\u4ddd\u3cbf\u4dc5\u3bfb\u4de0\u2774\u4dd5");

    protected BeforeLoadLocal(InjectionPointData data) {
        this(data, 21, false);
    }

    protected BeforeLoadLocal(InjectionPointData data, int opcode, boolean opcodeAfter) {
        super(data.getContext());
        this.returnType = data.getMethodReturnType();
        this.discriminator = data.getLocalVariableDiscriminator();
        this.opcode = data.getOpcode(this.returnType.getOpcode(opcode));
        this.ordinal = data.getOrdinal();
        this.opcodeAfter = opcodeAfter;
    }

    @Override
    boolean find(Target target, Collection<AbstractInsnNode> nodes) {
        SearchState state = new SearchState(this.ordinal, this.discriminator.printLVT());
        ListIterator<AbstractInsnNode> iter = target.method.instructions.iterator();
        while (iter.hasNext()) {
            int local;
            AbstractInsnNode insn = iter.next();
            if (state.isPendingCheck()) {
                local = this.discriminator.findLocal(this.returnType, this.discriminator.isArgsOnly(), target, insn);
                state.check(nodes, insn, local);
                continue;
            }
            if (!(insn instanceof VarInsnNode) || insn.getOpcode() != this.opcode || this.ordinal != -1 && state.success()) continue;
            state.register((VarInsnNode)insn);
            if (this.opcodeAfter) {
                state.setPendingCheck();
                continue;
            }
            local = this.discriminator.findLocal(this.returnType, this.discriminator.isArgsOnly(), target, insn);
            state.check(nodes, insn, local);
        }
        return state.success();
    }

    static class SearchState {
        private boolean pendingCheck = false;
        private boolean found = false;
        private VarInsnNode varNode;
        private int ordinal = 0;
        private final boolean print;
        private final int targetOrdinal;
        private static final NMSLException \u8bba\u519b\u4e8b\u548c\u5386\u53f2 = new NMSLException("\ua687\ua678\u2700\ua668\u4dc5\u4411\u276c\u27b8\u2762\u4dd7\u4de4\ua643\u2739\u274d\ua646\u4dfe\u4258\u45f6\u4de8\u26e4\u4df5\u270b\u4dff\u4df7\u270f\u4dd3\u27ab\u4dce\u2781\u26e1\u4df9\u4dc8\ua68e\u2696\u3ee6\u2719\u4dfd");

        boolean isPendingCheck() {
            return this.pendingCheck;
        }

        void check(Collection<AbstractInsnNode> nodes, AbstractInsnNode insn, int local) {
            this.pendingCheck = false;
            if (!(local == this.varNode.var || local <= -2 && this.print)) {
                return;
            }
            if (this.targetOrdinal == -1 || this.targetOrdinal == this.ordinal) {
                nodes.add(insn);
                this.found = true;
            }
            ++this.ordinal;
            this.varNode = null;
        }

        void register(VarInsnNode node) {
            this.varNode = node;
        }

        boolean success() {
            return this.found;
        }

        SearchState(int targetOrdinal, boolean print) {
            this.targetOrdinal = targetOrdinal;
            this.print = print;
        }

        void setPendingCheck() {
            this.pendingCheck = true;
        }
    }
}

